/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import link.star_dust.MinerTrack.FoliaCheck;
import link.star_dust.MinerTrack.MinerTrack;
import link.star_dust.MinerTrack.managers.ViolationManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MiningListener
implements Listener {
    private final MinerTrack plugin;
    private final Map<UUID, Map<String, List<Location>>> miningPath = new HashMap<UUID, Map<String, List<Location>>>();
    private final Map<UUID, Long> lastMiningTime = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> violationLevel = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> minedVeinCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Map<String, Location>> lastVeinLocation = new HashMap<UUID, Map<String, Location>>();
    private final Map<UUID, Map<String, Set<Location>>> lastVeinClusters = new HashMap<UUID, Map<String, Set<Location>>>();
    private final Map<UUID, Map<Location, Long>> placedOres = new HashMap<UUID, Map<Location, Long>>();
    private final Map<Location, Long> explosionExposedOres = new HashMap<Location, Long>();
    private final Map<UUID, Long> vlZeroTimestamp = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> airViolationLevel = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastAirViolationTime = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> totalTurns = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> branchCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> yChanges = new HashMap<UUID, Integer>();

    public MiningListener(MinerTrack plugin) {
        this.plugin = plugin;
        int interval = 1200;
        if (FoliaCheck.isFolia()) {
            try {
                Class<?> schedulerClass = Class.forName("org.bukkit.Bukkit");
                Object scheduler = schedulerClass.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
                scheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Class.forName("java.util.function.Consumer"), Long.TYPE, Long.TYPE).invoke(scheduler, new Object[]{plugin, task -> {
                    try {
                        if (!plugin.isEnabled()) {
                            task.getClass().getMethod("cancel", new Class[0]).invoke(task, new Object[0]);
                            return;
                        }
                        this.checkAndResetPaths();
                        this.cleanUpAirViolations();
                        this.cleanupExpiredPaths();
                        this.cleanupExpiredExplosions();
                        this.cleanupExpiredPlacedBlocks();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, interval, interval});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new BukkitRunnable(){

                public void run() {
                    MiningListener.this.checkAndResetPaths();
                    MiningListener.this.cleanUpAirViolations();
                    MiningListener.this.cleanupExpiredPaths();
                    MiningListener.this.cleanupExpiredExplosions();
                    MiningListener.this.cleanupExpiredPlacedBlocks();
                }
            }.runTaskTimer((Plugin)plugin, (long)interval, (long)interval);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.plugin.getVerbosePlayers().remove(playerUUID);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfig().getBoolean("xray.enable", true)) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Material blockType = event.getBlock().getType();
        List rareOres = this.plugin.getConfig().getStringList("xray.rare-ores");
        if (rareOres.contains(blockType.name())) {
            this.placedOres.putIfAbsent(playerId, new HashMap());
            this.placedOres.get(playerId).put(event.getBlock().getLocation(), System.currentTimeMillis());
        }
    }

    private boolean isPlayerPlacedBlock(Location blockLocation) {
        long now = System.currentTimeMillis();
        long expirationTime = (long)(this.plugin.getConfig().getInt("xray.trace_remove", 15) * 60) * 1000L;
        ArrayList<UUID> emptyOwners = new ArrayList<UUID>();
        for (Map.Entry<UUID, Map<Location, Long>> entry : this.placedOres.entrySet()) {
            UUID owner = entry.getKey();
            Map<Location, Long> map = entry.getValue();
            Long placedAt = map.get(blockLocation);
            if (placedAt != null) {
                if (now - placedAt <= expirationTime) {
                    return true;
                }
                map.remove(blockLocation);
            }
            if (!map.isEmpty()) continue;
            emptyOwners.add(owner);
        }
        for (UUID id : emptyOwners) {
            this.placedOres.remove(id);
        }
        return false;
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        Player sourcePlayer = null;
        if (entity instanceof TNTPrimed) {
            TNTPrimed tnt = (TNTPrimed)entity;
            var7_5 = tnt.getSource();
            if (var7_5 instanceof Player) {
                sourcePlayer = player = (Player)var7_5;
            }
        } else if (entity instanceof ExplosiveMinecart) {
            ExplosiveMinecart minecart = (ExplosiveMinecart)entity;
            var7_5 = ((TNTPrimed)minecart).getSource();
            if (var7_5 instanceof Player) {
                sourcePlayer = player = (Player)var7_5;
            }
        } else if (entity instanceof EnderCrystal || entity instanceof WitherSkull || entity instanceof Creeper) {
            return;
        }
        if (sourcePlayer != null) {
            UUID playerId = sourcePlayer.getUniqueId();
            List rareOres = this.plugin.getConfig().getStringList("xray.rare-ores");
            long currentTime = System.currentTimeMillis();
            int retentionTime = this.plugin.getConfig().getInt("xray.explosion.explosion_retention_time", 600) * 1000;
            int totalBlocks = 0;
            int rareOresCount = 0;
            for (Block block : event.blockList()) {
                Location blockLocation = block.getLocation();
                if (this.isPlayerPlacedBlock(blockLocation)) continue;
                ++totalBlocks;
                if (!rareOres.contains(block.getType().name())) continue;
                ++rareOresCount;
                this.explosionExposedOres.put(block.getLocation(), currentTime + (long)retentionTime);
            }
            if (totalBlocks == 0) {
                return;
            }
            double hitRate = (double)rareOresCount / (double)totalBlocks;
            double suspiciousThreshold = this.plugin.getConfig().getDouble("xray.explosion.suspicious_hit_rate", 0.1);
            if (hitRate > suspiciousThreshold) {
                this.handleSuspiciousExplosion(sourcePlayer, rareOresCount, hitRate);
            }
        }
    }

    private void handleSuspiciousExplosion(Player player, int rareOresCount, double hitRate) {
        UUID playerId = player.getUniqueId();
        int currentVL = this.violationLevel.getOrDefault(playerId, 0);
        int increaseAmount = this.calculateExplosionVLIncrease(rareOresCount, hitRate);
        this.violationLevel.put(playerId, currentVL + increaseAmount);
    }

    private int calculateExplosionVLIncrease(int rareOresCount, double hitRate) {
        double baseRate = this.plugin.getConfig().getDouble("xray.explosion.base_vl_rate", 2.0);
        return (int)Math.ceil((double)rareOresCount * hitRate * baseRate);
    }

    private void cleanupExpiredExplosions() {
        long currentTime = System.currentTimeMillis();
        this.explosionExposedOres.entrySet().removeIf(entry -> currentTime > (Long)entry.getValue());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.getConfig().getBoolean("xray.enable", true)) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Material blockType = event.getBlock().getType();
        Location blockLocation = event.getBlock().getLocation();
        if (this.isPlayerPlacedBlock(blockLocation)) {
            return;
        }
        List rareOres = this.plugin.getConfig().getStringList("xray.rare-ores");
        if (!player.hasPermission("minertrack.bypass") || player.hasPermission("minertrack.bypass") && this.plugin.getConfigManager().DisableBypass()) {
            if (this.violationLevel.getOrDefault(playerId, 0) == 0) {
                this.vlZeroTimestamp.put(playerId, System.currentTimeMillis());
            }
            String worldName = player.getWorld().getName();
            if (!this.plugin.getConfigManager().isWorldDetectionEnabled(worldName)) {
                return;
            }
            int maxHeight = this.plugin.getConfigManager().getWorldMaxHeight(worldName);
            if (maxHeight != -1 && blockLocation.getY() > (double)maxHeight) {
                return;
            }
            if (this.explosionExposedOres.containsKey(blockLocation)) {
                long expirationTime = this.explosionExposedOres.get(blockLocation);
                if (System.currentTimeMillis() < expirationTime) {
                    return;
                }
                this.explosionExposedOres.remove(blockLocation);
            }
            if (rareOres.contains(blockType.name())) {
                this.handleXRayDetection(player, blockType, blockLocation);
            }
        }
    }

    private void handleXRayDetection(Player player, Material blockType, Location blockLocation) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        int maxPathLength = this.plugin.getConfig().getInt("xray.max_path_length", 500);
        this.miningPath.putIfAbsent(playerId, new HashMap());
        Map<String, List<Location>> worldPaths = this.miningPath.get(playerId);
        String worldName = blockLocation.getWorld().getName();
        worldPaths.putIfAbsent(worldName, new ArrayList());
        List<Location> path = worldPaths.get(worldName);
        path.add(blockLocation);
        this.lastMiningTime.put(playerId, currentTime);
        if (path.size() > maxPathLength) {
            path.remove(0);
        }
        this.checkForArtificialAir(player, path);
        if (!this.isInNaturalEnvironment(player, blockLocation, path) && !this.isSmoothPath(player.getUniqueId(), path) && this.isNewVein(playerId, worldName, blockLocation, blockType)) {
            this.minedVeinCount.put(playerId, this.minedVeinCount.getOrDefault(playerId, 0) + 1);
            this.lastVeinLocation.putIfAbsent(playerId, new HashMap());
            this.lastVeinLocation.get(playerId).put(worldName, blockLocation);
            int veinCount = this.minedVeinCount.getOrDefault(playerId, 0);
            if (veinCount >= this.plugin.getConfigManager().getVeinCountThreshold()) {
                this.analyzeMiningPath(player, path, blockType, this.countVeinBlocks(blockLocation, blockType), blockLocation);
            }
        }
    }

    private void cleanupExpiredPaths() {
        long lastTime;
        long now = System.currentTimeMillis();
        long traceBackLength = this.plugin.getConfigManager().traceBackLength();
        HashSet<UUID> playersToClear = new HashSet<UUID>();
        for (Map.Entry<UUID, Map<String, List<Location>>> entry : this.miningPath.entrySet()) {
            UUID playerId = entry.getKey();
            Map<String, List<Location>> paths = entry.getValue();
            lastTime = this.lastMiningTime.getOrDefault(playerId, 0L);
            if (lastTime > 0L && now - lastTime > traceBackLength) {
                playersToClear.add(playerId);
                continue;
            }
            paths.values().forEach(path -> {
                if (lastTime > 0L) {
                    path.removeIf(loc -> now - lastTime > traceBackLength);
                }
            });
        }
        for (UUID uuid : playersToClear) {
            this.miningPath.remove(uuid);
            this.lastMiningTime.remove(uuid);
        }
        HashSet<UUID> clustersToRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, Map<String, Set<Location>>> e : this.lastVeinClusters.entrySet()) {
            UUID playerId = e.getKey();
            lastTime = this.lastMiningTime.getOrDefault(playerId, 0L);
            if (lastTime <= 0L || now - lastTime <= traceBackLength) continue;
            clustersToRemove.add(playerId);
        }
        for (UUID uuid : clustersToRemove) {
            this.lastVeinClusters.remove(uuid);
            this.lastVeinLocation.remove(uuid);
            this.minedVeinCount.remove(uuid);
        }
    }

    private boolean isNewVein(UUID playerId, String worldName, Location location, Material oreType) {
        Map lastLocations = this.lastVeinLocation.getOrDefault(playerId, new HashMap());
        Location lastLocation = (Location)lastLocations.get(worldName);
        int maxDistance = this.plugin.getConfigManager().getMaxVeinDistance();
        int smallVeinThreshold = this.plugin.getConfigManager().getSmallVeinSize();
        Set<Location> currentCluster = this.getVeinLocations(location, oreType, maxDistance);
        this.lastVeinClusters.putIfAbsent(playerId, new HashMap());
        Map<String, Set<Location>> playerClusters = this.lastVeinClusters.get(playerId);
        Set<Location> lastCluster = playerClusters.get(worldName);
        if (lastCluster == null || lastCluster.isEmpty()) {
            playerClusters.put(worldName, new HashSet<Location>(currentCluster));
            lastLocations.put(worldName, location);
            this.lastVeinLocation.put(playerId, lastLocations);
            return true;
        }
        if (lastLocation != null && lastLocation.getBlockX() == location.getBlockX() && lastLocation.getBlockY() == location.getBlockY() && lastLocation.getBlockZ() == location.getBlockZ() && lastLocation.getWorld().equals(location.getWorld())) {
            return false;
        }
        for (Location l : currentCluster) {
            if (!lastCluster.contains(l)) continue;
            lastCluster.addAll(currentCluster);
            playerClusters.put(worldName, lastCluster);
            return false;
        }
        double minDist = Double.MAX_VALUE;
        for (Location a : currentCluster) {
            for (Location b : lastCluster) {
                double d = a.distance(b);
                if (!(d < minDist)) continue;
                minDist = d;
            }
        }
        if (minDist <= (double)maxDistance) {
            lastCluster.addAll(currentCluster);
            playerClusters.put(worldName, lastCluster);
            return false;
        }
        int currentSize = currentCluster.size();
        int lastSize = lastCluster.size();
        if (currentSize > 0 && currentSize <= smallVeinThreshold && lastSize > 0 && lastSize <= smallVeinThreshold) {
            playerClusters.put(worldName, new HashSet<Location>(currentCluster));
            lastLocations.put(worldName, location);
            this.lastVeinLocation.put(playerId, lastLocations);
            return true;
        }
        if (minDist > (double)maxDistance) {
            playerClusters.put(worldName, new HashSet<Location>(currentCluster));
            lastLocations.put(worldName, location);
            this.lastVeinLocation.put(playerId, lastLocations);
            return true;
        }
        return false;
    }

    private Set<Location> getVeinLocations(Location startLocation, Material type, int maxDistance) {
        HashSet<Location> visited = new HashSet<Location>();
        LinkedList<Location> toVisit = new LinkedList<Location>();
        if (startLocation == null) {
            return visited;
        }
        double maxDistanceSq = (double)Math.max(1, maxDistance) * (double)Math.max(1, maxDistance);
        if (startLocation.getBlock().getType().equals((Object)type)) {
            toVisit.add(startLocation);
        } else {
            int seedRadius = Math.max(1, maxDistance);
            int baseX = startLocation.getBlockX();
            int baseY = startLocation.getBlockY();
            int baseZ = startLocation.getBlockZ();
            World world = startLocation.getWorld();
            for (int dx = -seedRadius; dx <= seedRadius; ++dx) {
                for (int dy = -seedRadius; dy <= seedRadius; ++dy) {
                    for (int dz = -seedRadius; dz <= seedRadius; ++dz) {
                        double distSq;
                        Location loc = new Location(world, (double)(baseX + dx), (double)(baseY + dy), (double)(baseZ + dz));
                        if (!loc.getWorld().equals(startLocation.getWorld()) || !((distSq = loc.distanceSquared(startLocation)) <= maxDistanceSq) || !loc.getBlock().getType().equals((Object)type)) continue;
                        toVisit.add(loc);
                    }
                }
            }
            if (toVisit.isEmpty()) {
                return visited;
            }
            visited.add(startLocation);
        }
        int safetyCap = 2000;
        while (!toVisit.isEmpty() && visited.size() < safetyCap) {
            Location current = (Location)toVisit.poll();
            if (visited.contains(current) || !current.getBlock().getType().equals((Object)type)) continue;
            visited.add(current);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        Location neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = current.clone().add((double)dx, (double)dy, (double)dz)) || !neighbor.getBlock().getType().equals((Object)type) || !neighbor.getWorld().equals(startLocation.getWorld()) || !(neighbor.distanceSquared(startLocation) <= maxDistanceSq)) continue;
                        toVisit.add(neighbor);
                    }
                }
            }
        }
        return visited;
    }

    public int countVeinBlocks(Location startLocation, Material type) {
        double maxDistance = this.plugin.getConfigManager().getMaxVeinDistance();
        Set<Location> vein = this.getVeinLocations(startLocation, type, (int)Math.max(1L, Math.round(maxDistance)));
        return vein.size();
    }

    private boolean isSmoothPath(UUID playerId, List<Location> path) {
        if (path.size() < 2) {
            return true;
        }
        int turnThreshold = this.plugin.getConfigManager().getTurnCountThreshold();
        int branchThreshold = this.plugin.getConfigManager().getBranchCountThreshold();
        int yChangeThreshold = this.plugin.getConfigManager().getYChangeThreshold();
        int playerTotalTurns = this.totalTurns.getOrDefault(playerId, 0);
        int playerBranchCount = this.branchCount.getOrDefault(playerId, 0);
        int playerYChanges = this.yChanges.getOrDefault(playerId, 0);
        Location lastLocation = null;
        Vector lastDirection = null;
        for (int i = 0; i < path.size(); ++i) {
            Location currentLocation = path.get(i);
            if (lastLocation != null) {
                Location prevLocation;
                Vector prevDirection;
                double dotProduct;
                Vector currentDirection = currentLocation.toVector().subtract(lastLocation.toVector()).normalize();
                if (lastDirection != null && (dotProduct = lastDirection.dot(currentDirection)) < Math.cos(Math.toRadians(30.0))) {
                    ++playerTotalTurns;
                }
                if (Math.abs(currentLocation.getY() - lastLocation.getY()) > (double)this.plugin.getConfigManager().getYPosChangeThresholdAddRequired()) {
                    ++playerYChanges;
                }
                if (i > 1 && (double)currentDirection.angle(prevDirection = (prevLocation = path.get(i - 1)).toVector().subtract(lastLocation.toVector()).normalize()) > Math.toRadians(60.0)) {
                    ++playerBranchCount;
                }
                lastDirection = currentDirection;
            }
            lastLocation = currentLocation;
        }
        this.totalTurns.put(playerId, playerTotalTurns);
        this.branchCount.put(playerId, playerBranchCount);
        this.yChanges.put(playerId, playerYChanges);
        return playerTotalTurns < turnThreshold && playerBranchCount < branchThreshold && playerYChanges < yChangeThreshold;
    }

    private boolean isInNaturalEnvironment(Player player, Location location, List<Location> path) {
        if (!this.plugin.getConfigManager().getNaturalEnable()) {
            return false;
        }
        int airCount = 0;
        int waterCount = 0;
        int lavaCount = 0;
        int caveAirMultiplier = this.plugin.getConfigManager().getCaveAirMultiplier();
        int airThreshold = this.plugin.getConfigManager().getCaveBypassAirThreshold();
        int detectionRange = this.plugin.getConfigManager().getCaveDetectionRange();
        int waterThreshold = this.plugin.getConfigManager().getWaterThreshold();
        int lavaThreshold = this.plugin.getConfigManager().getLavaThreshold();
        boolean checkRunningWater = this.plugin.getConfigManager().isRunningWaterCheckEnabled();
        int baseX = location.getBlockX();
        int baseY = location.getBlockY();
        int baseZ = location.getBlockZ();
        for (int x = -detectionRange; x <= detectionRange; ++x) {
            for (int y = -detectionRange; y <= detectionRange; ++y) {
                block8: for (int z = -detectionRange; z <= detectionRange; ++z) {
                    Material type = location.getWorld().getBlockAt(baseX + x, baseY + y, baseZ + z).getType();
                    switch (type) {
                        case CAVE_AIR: {
                            airCount += caveAirMultiplier;
                            continue block8;
                        }
                        case AIR: {
                            ++airCount;
                            continue block8;
                        }
                        case WATER: {
                            if (!checkRunningWater && !this.isWaterStill(location.getWorld(), baseX + x, baseY + y, baseZ + z)) continue block8;
                            ++waterCount;
                            continue block8;
                        }
                        case LAVA: {
                            ++lavaCount;
                            continue block8;
                        }
                    }
                }
            }
        }
        if (airCount > airThreshold && this.plugin.getConfigManager().isCaveSkipVL() && this.airViolationLevel.getOrDefault(player, 0) < this.plugin.getConfigManager().AirMonitorVLT()) {
            return true;
        }
        if (waterCount > waterThreshold && this.plugin.getConfigManager().isSeaSkipVL()) {
            return true;
        }
        return lavaCount > lavaThreshold && this.plugin.getConfigManager().isLavaSeaSkipVL();
    }

    private boolean isWaterStill(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        if (block.getType() == Material.WATER) {
            return block.getBlockData() instanceof Levelled && ((Levelled)block.getBlockData()).getLevel() == 0;
        }
        return false;
    }

    private void analyzeMiningPath(Player player, List<Location> path, Material blockType, int count, Location blockLocation) {
        UUID playerId = player.getUniqueId();
        Map lastVeins = this.lastVeinLocation.getOrDefault(playerId, new HashMap());
        String worldName = blockLocation.getWorld().getName();
        Location lastVeinLocation = (Location)lastVeins.get(worldName);
        int disconnectedSegments = 0;
        double totalDistance = 0.0;
        Location lastLocation = null;
        for (Location currentLocation : path) {
            if (lastLocation != null) {
                double distance = currentLocation.distance(lastLocation);
                totalDistance += distance;
                if (distance > 3.0) {
                    ++disconnectedSegments;
                }
            }
            lastLocation = currentLocation;
        }
        int veinCount = this.minedVeinCount.getOrDefault(playerId, 0);
        this.increaseViolationLevel(player, 1, blockType.name(), count, veinCount, blockLocation);
    }

    private boolean isPathConnected(Location start, Location end, List<Location> path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        double maxDistance = this.plugin.getConfigManager().getMaxVeinDistance();
        HashSet<Location> visited = new HashSet<Location>();
        LinkedList<Location> queue = new LinkedList<Location>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Location current = (Location)queue.poll();
            if (current.distance(end) <= maxDistance) {
                return true;
            }
            for (Location point : path) {
                if (visited.contains(point) || !(current.distance(point) <= maxDistance)) continue;
                queue.add(point);
                visited.add(point);
            }
        }
        return false;
    }

    private void checkForArtificialAir(Player player, List<Location> path) {
        double threshold;
        if (!this.plugin.getConfig().getBoolean("xray.natural-detection.cave.air-monitor.enable", true)) {
            return;
        }
        int minPathLength = this.plugin.getConfig().getInt("xray.natural-detection.cave.air-monitor.min-path-length", 10);
        if (path.size() < minPathLength) {
            return;
        }
        int airBlockCount = 0;
        for (Location loc : path) {
            Material type = loc.getBlock().getType();
            if (type != Material.AIR && type != Material.CAVE_AIR) continue;
            ++airBlockCount;
        }
        double airRatio = (double)airBlockCount / (double)path.size();
        if (airRatio > (threshold = this.plugin.getConfig().getDouble("xray.natural-detection.cave.air-monitor.air-ratio-threshold", 0.3))) {
            UUID playerId = player.getUniqueId();
            int increase = this.plugin.getConfig().getInt("xray.natural-detection.cave.air-monitor.violation-increase", 1);
            this.airViolationLevel.put(playerId, this.airViolationLevel.getOrDefault(playerId, 0) + increase);
            this.lastAirViolationTime.put(playerId, System.currentTimeMillis());
        }
    }

    private void cleanupExpiredPlacedBlocks() {
        long currentTime = System.currentTimeMillis();
        long expirationTime = (long)(this.plugin.getConfig().getInt("xray.trace_remove", 15) * 60) * 1000L;
        ArrayList<UUID> ownersToRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Map<Location, Long>> entry : this.placedOres.entrySet()) {
            UUID owner = entry.getKey();
            Map<Location, Long> map = entry.getValue();
            map.entrySet().removeIf(e -> currentTime - (Long)e.getValue() > expirationTime);
            if (!map.isEmpty()) continue;
            ownersToRemove.add(owner);
        }
        for (UUID id : ownersToRemove) {
            this.placedOres.remove(id);
        }
    }

    private void cleanUpAirViolations() {
        long now = System.currentTimeMillis();
        long decayTime = this.plugin.getConfig().getLong("xray.natural-detection.cave.air-monitor.remove-time", 20L) * 60L * 1000L;
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Long> entry : this.lastAirViolationTime.entrySet()) {
            if (now - entry.getValue() <= decayTime) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID uuid : toRemove) {
            this.airViolationLevel.remove(uuid);
            this.lastAirViolationTime.remove(uuid);
        }
    }

    private void checkAndResetPaths() {
        long now = System.currentTimeMillis();
        long traceRemoveMillis = (long)(this.plugin.getConfig().getInt("xray.trace_remove", 15) * 60) * 1000L;
        for (UUID playerId : new HashSet<UUID>(this.vlZeroTimestamp.keySet())) {
            Long lastZeroTime = this.vlZeroTimestamp.get(playerId);
            int vl = ViolationManager.getViolationLevel(playerId);
            if (lastZeroTime == null || vl != 0 || now - lastZeroTime <= traceRemoveMillis) continue;
            this.miningPath.remove(playerId);
            this.minedVeinCount.remove(playerId);
            this.vlZeroTimestamp.remove(playerId);
            this.totalTurns.remove(playerId);
            this.branchCount.remove(playerId);
            this.yChanges.remove(playerId);
        }
    }

    public void checkAndResetPaths(UUID playerId) {
        if (playerId == null) {
            return;
        }
        this.miningPath.remove(playerId);
        this.lastMiningTime.remove(playerId);
        this.minedVeinCount.remove(playerId);
        this.lastVeinLocation.remove(playerId);
        this.lastVeinClusters.remove(playerId);
        this.placedOres.remove(playerId);
        this.vlZeroTimestamp.remove(playerId);
        this.airViolationLevel.remove(playerId);
        this.lastAirViolationTime.remove(playerId);
        this.totalTurns.remove(playerId);
        this.branchCount.remove(playerId);
        this.yChanges.remove(playerId);
    }

    private void increaseViolationLevel(Player player, int amount, String blockType, int count, int vein, Location location) {
        UUID playerId = player.getUniqueId();
        this.violationLevel.put(playerId, this.violationLevel.getOrDefault(playerId, 0) + amount);
        this.vlZeroTimestamp.remove(playerId);
        this.plugin.getViolationManager().increaseViolationLevel(player, amount, blockType, count, vein, location);
    }
}

