/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.managers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import link.star_dust.MinerTrack.MinerTrack;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final MinerTrack plugin;
    private YamlConfiguration languageConfig;
    private final File languageFile;
    private static LanguageManager instance;

    public LanguageManager(MinerTrack plugin) {
        this.plugin = plugin;
        this.languageFile = new File(plugin.getDataFolder(), "language.yml");
        this.loadLanguageFile();
    }

    public void loadLanguageFile() {
        if (!this.languageFile.exists()) {
            this.plugin.saveResource("language.yml", false);
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)this.languageFile);
        try (InputStream defaultStream = this.plugin.getResource("language.yml");){
            if (defaultStream != null) {
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
                this.languageConfig.setDefaults((Configuration)defaultConfig);
                this.languageConfig.options().copyDefaults(true);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load default language configuration: " + e.getMessage());
        }
        this.saveCustomLanguageFile();
    }

    public static LanguageManager getInstance(MinerTrack plugin) {
        if (instance == null) {
            instance = new LanguageManager(plugin);
        }
        return instance;
    }

    public void reloadLanguage() {
        this.reloadLanguageFile();
    }

    public String getKickMessage(String playerName) {
        return this.applyColors(this.getMessage("kick-format").replace("%player%", playerName));
    }

    public String getPrefix() {
        return this.applyColors(this.getMessage("prefix"));
    }

    public List<String> getHelpMessages() {
        List helpMessages = this.languageConfig.getStringList("help");
        return helpMessages.stream().map(this::applyColors).collect(Collectors.toList());
    }

    public String getPrefixedMessage(String key) {
        return this.getPrefix() + " " + this.applyColors(this.getMessage(key));
    }

    public String getMessage(String path) {
        return this.languageConfig.getString(path);
    }

    public String getColoredMessage(String path) {
        return this.applyColors(this.languageConfig.getString(path));
    }

    public String applyColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getLogFormat() {
        return this.getMessage("log-format");
    }

    public boolean isKickBroadcastEnabled() {
        return this.languageConfig.getBoolean("kick-broadcast", true);
    }

    public String logNotFound(String log_name) {
        return this.applyColors(this.getMessage("log-not-found").replace("{log_file}", log_name));
    }

    public int getLogViewerLinesPerPage() {
        return this.languageConfig.getInt("log-viewer-lines-per-page", 10);
    }

    private void saveCustomLanguageFile() {
        try {
            this.languageConfig.save(this.languageFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save custom language configuration to " + this.languageFile.getName() + ": " + e.getMessage());
        }
    }

    public void reloadLanguageFile() {
        try {
            this.languageConfig.load(this.languageFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getLogger().severe("Could not reload language configuration: " + e.getMessage());
        }
    }

    public String getPrefixedMessageWithDefault(String key, String defaultMessage) {
        String message = this.getMessage(key);
        if (message == null || message.isEmpty()) {
            message = defaultMessage;
        }
        return this.applyColors(this.getPrefix() + message);
    }
}

