/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.managers;

import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import link.star_dust.MinerTrack.FoliaCheck;
import link.star_dust.MinerTrack.MinerTrack;
import link.star_dust.MinerTrack.hooks.CustomJsonWebHook;
import link.star_dust.MinerTrack.hooks.DiscordWebHook;
import link.star_dust.MinerTrack.listeners.MiningListener;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ViolationManager {
    private final MinerTrack plugin;
    private static final Map<UUID, Integer> violationLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> vlZeroTimestamp = new HashMap<UUID, Long>();
    private final Map<UUID, Long> vlChangedTimestamp = new HashMap<UUID, Long>();
    private final Map<UUID, Object> vlDecayTasks = new HashMap<UUID, Object>();
    private String currentLogFileName;

    public ViolationManager(final MinerTrack plugin) {
        this.plugin = plugin;
        this.currentLogFileName = this.generateLogFileName();
        int interval = 1200;
        if (FoliaCheck.isFolia()) {
            try {
                Class<?> schedulerClass = Class.forName("org.bukkit.Bukkit");
                Object scheduler = schedulerClass.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
                scheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Class.forName("java.util.function.Consumer"), Long.TYPE, Long.TYPE).invoke(scheduler, new Object[]{plugin, task -> {
                    try {
                        if (!plugin.isEnabled()) {
                            task.getClass().getMethod("cancel", new Class[0]).invoke(task, new Object[0]);
                            return;
                        }
                        this.processVLDecayTasks();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, interval, interval});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new BukkitRunnable(){

                public void run() {
                    if (!plugin.isEnabled()) {
                        this.cancel();
                        return;
                    }
                    ViolationManager.this.processVLDecayTasks();
                }
            }.runTaskTimer((Plugin)plugin, (long)interval, (long)interval);
        }
    }

    private String generateLogFileName() {
        File logFile;
        LocalDate date = LocalDate.now();
        String formattedDate = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        File logDir = new File(this.plugin.getDataFolder(), "logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            Bukkit.getLogger().warning("Could not create logs directory for MinerTrack.");
        }
        int index = 1;
        do {
            logFile = new File(logDir, String.format("%s-%d%s.log", formattedDate, index, this.getOrdinalSuffix(index)));
            ++index;
        } while (logFile.exists());
        return logFile.getName();
    }

    private String getLogFileName() {
        if (this.currentLogFileName == null) {
            this.currentLogFileName = this.generateLogFileName();
        }
        return this.currentLogFileName;
    }

    private String getOrdinalSuffix(int index) {
        if (index >= 11 && index <= 13) {
            return "th";
        }
        switch (index % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private void logViolation(Player player, int vl, int addVl, String blockType, int count, int vein, Location location) {
        if (!this.plugin.getConfig().getBoolean("log_file")) {
            return;
        }
        String logFormat = this.plugin.getLanguageManager().getLogFormat();
        String worldName = location.getWorld() != null ? location.getWorld().getName() : "unknown";
        LocalDateTime now = LocalDateTime.now();
        String year = String.valueOf(now.getYear());
        String month = String.format("%02d", now.getMonthValue());
        String day = String.format("%02d", now.getDayOfMonth());
        String hour = String.format("%02d", now.getHour());
        String minute = String.format("%02d", now.getMinute());
        String second = String.format("%02d", now.getSecond());
        String formattedMessage = logFormat.replace("%year%", year).replace("%month%", month).replace("%day%", day).replace("%hour%", hour).replace("%minute%", minute).replace("%second%", second).replace("%player%", player.getName()).replace("%vl%", String.valueOf(vl)).replace("%add_vl%", String.valueOf(addVl)).replace("%block_type%", blockType).replace("%count%", String.valueOf(count)).replace("%vein_count%", String.valueOf(vein)).replace("%world%", worldName).replace("%pos_x%", String.valueOf(location.getBlockX())).replace("%pos_y%", String.valueOf(location.getBlockY())).replace("%pos_z%", String.valueOf(location.getBlockZ()));
        String fileName = this.getLogFileName();
        File logDir = new File(this.plugin.getDataFolder(), "logs");
        File logFile = new File(logDir, fileName);
        try (FileWriter writer = new FileWriter(logFile, true);){
            writer.write(formattedMessage + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void logCommand(String command) {
        if (!this.plugin.getConfig().getBoolean("log_file")) {
            return;
        }
        String fileName = this.getLogFileName();
        File logDir = new File(this.plugin.getDataFolder(), "logs");
        File logFile = new File(logDir, fileName);
        try (FileWriter writer = new FileWriter(logFile, true);){
            writer.write("Excuted Command: " + command + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getViolationLevel(UUID uuid) {
        return violationLevels.getOrDefault(uuid, 0);
    }

    public int getViolationLevel(Player player) {
        return violationLevels.getOrDefault(player.getUniqueId(), 0);
    }

    public void increaseViolationLevel(Player player, int increment, String blockType, int count, int vein, Location location) {
        long now = System.currentTimeMillis();
        UUID playerId = player.getUniqueId();
        this.vlZeroTimestamp.remove(playerId);
        this.vlChangedTimestamp.put(playerId, now);
        if (this.vlDecayTasks.containsKey(playerId)) {
            this.cancelVLDecayTask(playerId);
            this.vlDecayTasks.remove(playerId);
        }
        this.scheduleVLDecayTask(player);
        int oldLevel = ViolationManager.getViolationLevel(playerId);
        int newLevel = oldLevel + increment;
        violationLevels.put(playerId, newLevel);
        if (this.plugin.getConfig().isConfigurationSection("xray.commands")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("xray.commands").getKeys(false)) {
                int threshold = Integer.parseInt(key);
                if (threshold <= oldLevel || threshold > newLevel) continue;
                Object raw = this.plugin.getConfig().get("xray.commands." + key);
                ArrayList<String> commandsToRun = new ArrayList<String>();
                if (raw instanceof List) {
                    for (Object o : (List)raw) {
                        if (o == null) continue;
                        commandsToRun.add(String.valueOf(o));
                    }
                } else if (raw != null) {
                    commandsToRun.add(String.valueOf(raw));
                }
                for (String commandTemplate : commandsToRun) {
                    if (commandTemplate == null || commandTemplate.trim().isEmpty()) continue;
                    String command = commandTemplate.replace("%player%", player.getName());
                    if (FoliaCheck.isFolia()) {
                        RegionScheduler regionScheduler = Bukkit.getRegionScheduler();
                        regionScheduler.run((Plugin)this.plugin, location, scheduledTask -> Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                            this.logCommand(command);
                        }));
                        continue;
                    }
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    this.logCommand(command);
                }
            }
        }
        if (newLevel >= 1) {
            String verboseFormat = this.plugin.getLanguageManager().getPrefixedMessage("verbose-format");
            String worldName = location.getWorld() != null ? location.getWorld().getName() : "unknown";
            String formattedMessage = verboseFormat.replace("%player%", player.getName()).replace("%vl%", String.valueOf(newLevel)).replace("%add_vl%", String.valueOf(increment)).replace("%block_type%", blockType).replace("%count%", String.valueOf(count)).replace("%vein_count%", String.valueOf(vein)).replace("%world%", worldName).replace("%pos_x%", String.valueOf(location.getBlockX())).replace("%pos_y%", String.valueOf(location.getBlockY())).replace("%pos_z%", String.valueOf(location.getBlockZ()));
            for (UUID uuid : this.plugin.getVerbosePlayers()) {
                Player verbosePlayer = Bukkit.getPlayer((UUID)uuid);
                if (verbosePlayer == null || !verbosePlayer.hasPermission("minertrack.verbose")) continue;
                verbosePlayer.sendMessage(formattedMessage);
            }
            if (this.plugin.isVerboseConsoleEnabled()) {
                Bukkit.getConsoleSender().sendMessage(formattedMessage);
            }
            this.logViolation(player, newLevel, increment, blockType, count, vein, location);
            if (this.plugin.getConfigManager().WebHookEnable() && newLevel >= this.plugin.getConfigManager().WebHookVLRequired()) {
                this.WebHook(playerId, blockType, vein, count, location);
            }
        }
    }

    public void processVLDecayTasks() {
        long now = System.currentTimeMillis();
        for (UUID playerId : new HashSet<UUID>(violationLevels.keySet())) {
            int currentVL = violationLevels.getOrDefault(playerId, 0);
            if (currentVL > 0) {
                long decayIntervalMillis = (long)(this.plugin.getConfig().getInt("xray.decay.interval", 3) * 60) * 1000L;
                Long lastChangedTime = this.vlChangedTimestamp.get(playerId);
                if (lastChangedTime == null || now - lastChangedTime <= decayIntervalMillis) continue;
                int decayAmount = this.plugin.getConfig().getInt("xray.decay.amount", 1);
                double decayFactor = this.plugin.getConfig().getDouble("xray.decay.factor", 0.9);
                boolean useFactor = this.plugin.getConfig().getBoolean("xray.decay.use_factor", false);
                int newVL = useFactor ? (int)Math.ceil((double)currentVL * decayFactor) : Math.max(0, currentVL - decayAmount);
                violationLevels.put(playerId, newVL);
                this.vlChangedTimestamp.put(playerId, now);
                if (newVL != 0) continue;
                this.vlZeroTimestamp.put(playerId, now);
                continue;
            }
            this.vlZeroTimestamp.putIfAbsent(playerId, now);
        }
    }

    private void scheduleVLDecayTask(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.vlDecayTasks.containsKey(playerId)) {
            return;
        }
        violationLevels.putIfAbsent(playerId, 0);
        this.vlZeroTimestamp.putIfAbsent(playerId, System.currentTimeMillis());
        this.vlDecayTasks.put(playerId, playerId);
    }

    private void cancelVLDecayTask(UUID playerId) {
        this.vlDecayTasks.remove(playerId);
    }

    private void WebHook(UUID playerId, String oreType, int minedVeins, int ore_count, Location location) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return;
        }
        String webHookURL = this.plugin.getConfigManager().WebHookURL();
        if (this.plugin.getConfigManager().isCustomJsonEnabled()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("player_uuid", player.getUniqueId().toString());
            placeholders.put("player_vl", String.valueOf(this.getViolationLevel(player)));
            placeholders.put("ore_type", oreType);
            placeholders.put("mined_veins", String.valueOf(minedVeins));
            placeholders.put("ore_count", String.valueOf(ore_count));
            placeholders.put("pos_x", String.valueOf(location.getBlockX()));
            placeholders.put("pos_y", String.valueOf(location.getBlockY()));
            placeholders.put("pos_z", String.valueOf(location.getBlockZ()));
            CustomJsonWebHook customWebHook = new CustomJsonWebHook(this.plugin, webHookURL, this.plugin.getConfigManager().getCustomJsonFormat());
            customWebHook.sendMessage(placeholders);
            return;
        }
        String title = this.plugin.getConfigManager().WebHookTitle();
        List<String> textTemplate = this.plugin.getConfigManager().WebHookText();
        int color = this.plugin.getConfigManager().WebHookColor();
        ArrayList<String> formattedText = new ArrayList<String>();
        for (String line : textTemplate) {
            formattedText.add(line.replace("%player%", player.getName()).replace("%player_uuid%", player.getUniqueId().toString()).replace("%player_vl%", String.valueOf(this.getViolationLevel(player))).replace("%ore_type%", oreType).replace("%mined_veins%", String.valueOf(minedVeins)).replace("%ore_count%", String.valueOf(ore_count)).replace("%pos_x%", String.valueOf(location.getBlockX())).replace("%pos_y%", String.valueOf(location.getBlockY())).replace("%pos_z%", String.valueOf(location.getBlockZ())));
        }
        String description = String.join((CharSequence)"\n", formattedText);
        DiscordWebHook discordWebHook = new DiscordWebHook(this.plugin, webHookURL);
        DiscordWebHook.Embed embed = new DiscordWebHook.Embed(title, description, color);
        discordWebHook.sendEmbed(embed);
    }

    public void resetViolationLevel(Player player) {
        UUID playerId = player.getUniqueId();
        violationLevels.remove(playerId);
        try {
            MiningListener listener = this.plugin.getMiningListener();
            if (listener != null) {
                listener.checkAndResetPaths(playerId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

