/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;

public class LogViewerUtils {
    private static final Map<CommandSender, LogCache> logCacheMap = new ConcurrentHashMap<CommandSender, LogCache>();

    public static LogCache getCache(CommandSender sender) {
        return logCacheMap.get(sender);
    }

    public static void putCache(CommandSender sender, LogCache cache) {
        logCacheMap.put(sender, cache);
    }

    public static void clearCache(CommandSender sender) {
        logCacheMap.remove(sender);
    }

    public static List<String> readLogFile(File logFile) throws IOException {
        return Files.readAllLines(logFile.toPath(), StandardCharsets.UTF_8);
    }

    public static int getTotalPages(int totalLines, int perPage) {
        return (int)Math.ceil((double)totalLines / (double)perPage);
    }

    public static int[] getPageRange(int totalLines, int page, int perPage) {
        int start = (page - 1) * perPage;
        int end = Math.min(start + perPage, totalLines);
        return new int[]{start, end};
    }

    public static class LogCache {
        public String logName;
        public List<String> lines;
        public int totalPages;
        public int currentPage;

        public LogCache(String logName, List<String> lines, int totalPages, int currentPage) {
            this.logName = logName;
            this.lines = lines;
            this.totalPages = totalPages;
            this.currentPage = currentPage;
        }
    }
}

