/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.mitl.maleficium.subroutine.SpeciesCheck;
import it.mitl.maleficium.subroutine.VariableManager;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium", value={Dist.CLIENT})
public class ExperienceBarColourChanger {
    @SubscribeEvent
    public static void onRenderExperienceBar(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.EXPERIENCE_BAR.type()) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return;
            }
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            if (player.m_20202_() != null) {
                return;
            }
            if ("human".equals(VariableManager.getSpecies((Entity)player))) {
                return;
            }
            XPColor color = ExperienceBarColourChanger.getXPColorForSpecies(Objects.requireNonNull(VariableManager.getSpecies((Entity)player)));
            event.setCanceled(true);
            GuiGraphics graphics = event.getGuiGraphics();
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int centerX = screenWidth / 2;
            int barWidth = 182;
            int x = centerX - barWidth / 2;
            int y = screenHeight - 32 + 3;
            int experienceBarLength = (int)(player.f_36080_ * (float)(barWidth + 1));
            ResourceLocation guiIcons = new ResourceLocation("textures/gui/icons.png");
            graphics.m_280218_(guiIcons, x, y, 0, 64, barWidth, 5);
            graphics.m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)color.r, (float)color.g, (float)color.b, (float)color.a);
            graphics.m_280218_(guiIcons, x, y, 0, 69, experienceBarLength, 5);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280168_().m_85849_();
            if (player.f_36078_ > 0) {
                String levelString = String.valueOf(player.f_36078_);
                int levelX = centerX - mc.f_91062_.m_92895_(levelString) / 2;
                int levelY = y - 9;
                graphics.m_280056_(mc.f_91062_, levelString, levelX, levelY, color.textColor, true);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderHungerBar(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().toString().equals("minecraft:food_level")) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return;
            }
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            if (player.m_20202_() != null) {
                return;
            }
            if (!SpeciesCheck.isAnyVampire((Player)player)) {
                return;
            }
            event.setCanceled(true);
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int foodLevel = player.m_36324_().m_38702_() + VariableManager.getExtraHunger((Entity)player);
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int xStart = screenWidth / 2 + 83;
            int yStart = screenHeight - 39;
            ResourceLocation HUNGER_ICONS = new ResourceLocation("maleficium", "textures/gui/blood_drops.png");
            for (int i = 0; i < 10; ++i) {
                int x = xStart - i * 8;
                int y = yStart;
                int u = foodLevel > 20 ? (foodLevel >= 21 + i * 2 ? 14 : (foodLevel == 21 + i * 2 - 1 ? 28 : 0)) : (foodLevel >= (i + 1) * 2 ? 0 : (foodLevel == i * 2 + 1 ? 7 : 21));
                guiGraphics.m_280163_(HUNGER_ICONS, x, y, (float)u, 0.0f, 7, 9, 35, 9);
            }
        }
    }

    private static XPColor getXPColorForSpecies(String species) {
        return switch (species) {
            case "vampire", "original_vampire" -> new XPColor(0.64705884f, 0.02745098f, 0.02745098f, 1.0f, 10815239);
            case "werewolf" -> new XPColor(0.2627451f, 0.17254902f, 0.03137255f, 1.0f, 4402184);
            case "witch" -> new XPColor(0.59607846f, 0.37254903f, 0.7294118f, 1.0f, 9985978);
            default -> new XPColor(0.0f, 0.0f, 0.0f, 1.0f, 0xFFFFFF);
        };
    }

    private static class XPColor {
        float r;
        float g;
        float b;
        float a;
        int textColor;

        XPColor(float r, float g, float b, float a, int textColor) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.textColor = textColor;
        }
    }
}

