/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import it.mitl.maleficium.mixin.accessor.HttpTextureAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;

public class GreyscaleSkinUtil {
    private static final Map<UUID, ResourceLocation> CACHE = new ConcurrentHashMap<UUID, ResourceLocation>();

    public static ResourceLocation getOrCreate(UUID uuid, ResourceLocation original) {
        ResourceLocation cached = CACHE.get(uuid);
        if (cached != null) {
            return cached;
        }
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation cacheLoc = ResourceLocation.parse((String)("maleficium:greyskins/" + String.valueOf(uuid)));
        NativeImage src = GreyscaleSkinUtil.loadNativeImageFor(original);
        if (src == null) {
            return null;
        }
        NativeImage grey = GreyscaleSkinUtil.toGreyscale(src);
        src.close();
        DynamicTexture dyn = new DynamicTexture(grey);
        mc.m_91097_().m_118495_(cacheLoc, (AbstractTexture)dyn);
        CACHE.put(uuid, cacheLoc);
        return cacheLoc;
    }

    private static NativeImage toGreyscale(NativeImage img) {
        int w = img.m_84982_();
        int h = img.m_85084_();
        NativeImage out = new NativeImage(w, h, false);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.m_84985_(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int lum = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                int grey = a << 24 | lum << 16 | lum << 8 | lum;
                out.m_84988_(x, y, grey);
            }
        }
        return out;
    }

    private static NativeImage loadNativeImageFor(ResourceLocation loc) {
        NativeImage nativeImage;
        block26: {
            InputStream is2;
            HttpTexture http;
            File f;
            Minecraft mc = Minecraft.m_91087_();
            AbstractTexture texture = mc.m_91097_().m_118506_(loc);
            if (texture instanceof HttpTexture && (f = GreyscaleSkinUtil.getHttpTextureFile(http = (HttpTexture)texture)) != null && f.exists()) {
                NativeImage nativeImage2;
                FileInputStream fis = new FileInputStream(f);
                try {
                    nativeImage2 = NativeImage.m_85058_((InputStream)fis);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                fis.close();
                return nativeImage2;
            }
            if (texture instanceof SimpleTexture) {
                block25: {
                    is2 = mc.m_91098_().m_215595_(loc);
                    try {
                        nativeImage = NativeImage.m_85058_((InputStream)is2);
                        if (is2 == null) break block25;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is2 != null) {
                                try {
                                    is2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException is2) {
                            // empty catch block
                        }
                    }
                    is2.close();
                }
                return nativeImage;
            }
            is2 = mc.m_91098_().m_215595_(loc);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)is2);
                if (is2 == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (is2 != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            is2.close();
        }
        return nativeImage;
    }

    private static File getHttpTextureFile(HttpTexture http) {
        try {
            return ((HttpTextureAccessor)http).maleficium$getFile();
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

