/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.mitl.maleficium.subroutine.VariableManager;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SetSpeciesCommand {
    private static final Set<String> VALID_SPECIES = Set.of("human", "vampire", "werewolf", "original_vampire");

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setspecies").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"species", (ArgumentType)StringArgumentType.string()).executes(arguments -> {
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null) {
                return 0;
            }
            String species = (String)arguments.getArgument("species", String.class);
            if (!VALID_SPECIES.contains(species)) {
                if (species.equals("witch")) {
                    entity.m_213846_((Component)Component.m_237113_((String)"\u00a78[\u00a77Maleficium\u00a78]\u00a7r Whoops! We've migrated this species to the '/maleficium setmagic' command. Please use that command to set your species to witch."));
                    return 0;
                }
                entity.m_213846_((Component)Component.m_237113_((String)("\u00a78[\u00a77Maleficium\u00a78]\u00a7r Invalid species! Valid options are: " + String.join((CharSequence)", ", VALID_SPECIES))));
                return 0;
            }
            VariableManager.setSpecies(species, entity);
            if ("vampire".equals(species) && VariableManager.getOriginalVampire(entity).equals("none")) {
                VariableManager.setOriginalVampire(entity, "server");
            }
            entity.m_213846_((Component)Component.m_237113_((String)("\u00a78[\u00a77Maleficium\u00a78]\u00a7r Success! You are now a \u00a7l" + species + "\u00a7r!" + VariableManager.getOriginalVampire(entity))));
            return 1;
        })));
    }
}

