/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.event.species.vampire;

import it.mitl.maleficium.config.MaleficiumCommonConfigs;
import it.mitl.maleficium.effect.ModEffects;
import it.mitl.maleficium.subroutine.SpeciesCheck;
import it.mitl.maleficium.subroutine.VariableManager;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium")
public class VampireAttributeEvent {
    private static final UUID STRENGTH_MODIFIER_UUID = UUID.fromString("07121894-24e4-49d2-9d75-d9e69ce9d0b8");
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("bb91da3f-c963-46b6-ad8c-43496a5dab3f");
    private static final UUID ORIGINAL_HEALTH_MODIFIER_UUID = UUID.fromString("5c55169d-4d00-4380-9ab5-64896fd78003");
    public static final UUID SPEED_MODIFIER_UUID = UUID.fromString("19ea251b-9560-49b2-881d-cb11f62e95a1");
    public static final UUID JUMP_MODIFIER_UUID = UUID.fromString("730b2a9f-62bd-4319-a789-225b12708bcf");

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        MobEffectInstance instance;
        boolean isDesiccated;
        Player player = event.player;
        if (player == null) {
            return;
        }
        boolean isAnyVampire = SpeciesCheck.isAnyVampire(player);
        boolean isOnlyVampire = SpeciesCheck.isOnlyVampire(player);
        boolean isOriginalVampire = SpeciesCheck.isOriginalVampire(player);
        boolean isHuman = "human".equals(VariableManager.getSpecies((Entity)player));
        boolean bl = isDesiccated = player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null;
        if (isAnyVampire && player.m_21223_() > 1.0f && !isDesiccated) {
            if (player.m_21051_(Attributes.f_22281_).m_22111_(STRENGTH_MODIFIER_UUID) == null) {
                player.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier(STRENGTH_MODIFIER_UUID, "Vampire strength boost", ((Double)MaleficiumCommonConfigs.VAMPIRE_STRENGTH_MULTIPLIER.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        } else {
            player.m_21051_(Attributes.f_22281_).m_22120_(STRENGTH_MODIFIER_UUID);
        }
        if (isAnyVampire) {
            if (isOriginalVampire) {
                if (player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_MODIFIER_UUID) != null) {
                    player.m_21051_(Attributes.f_22276_).m_22120_(HEALTH_MODIFIER_UUID);
                }
                if (player.m_21051_(Attributes.f_22276_).m_22111_(ORIGINAL_HEALTH_MODIFIER_UUID) == null) {
                    player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(ORIGINAL_HEALTH_MODIFIER_UUID, "Original vampire health boost", (Double)MaleficiumCommonConfigs.VAMPIRE_HEALTH_INCREASE.get() + 10.0, AttributeModifier.Operation.ADDITION));
                    player.m_21153_(player.m_21233_());
                }
            } else {
                if (player.m_21051_(Attributes.f_22276_).m_22111_(ORIGINAL_HEALTH_MODIFIER_UUID) != null) {
                    player.m_21051_(Attributes.f_22276_).m_22120_(ORIGINAL_HEALTH_MODIFIER_UUID);
                }
                if (player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_MODIFIER_UUID) == null) {
                    player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(HEALTH_MODIFIER_UUID, "Vampire health boost", ((Double)MaleficiumCommonConfigs.VAMPIRE_HEALTH_INCREASE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
                    player.m_21153_(player.m_21233_());
                }
            }
        } else {
            if (player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_MODIFIER_UUID) != null) {
                player.m_21051_(Attributes.f_22276_).m_22120_(HEALTH_MODIFIER_UUID);
                if (player.m_21223_() > player.m_21233_()) {
                    player.m_21153_(player.m_21233_());
                }
            }
            if (player.m_21051_(Attributes.f_22276_).m_22111_(ORIGINAL_HEALTH_MODIFIER_UUID) != null) {
                player.m_21051_(Attributes.f_22276_).m_22120_(ORIGINAL_HEALTH_MODIFIER_UUID);
                if (player.m_21223_() > player.m_21233_()) {
                    player.m_21153_(player.m_21233_());
                }
            }
        }
        if (isAnyVampire && VariableManager.isBuffed((Entity)player) && player.m_21223_() > 1.0f && !isDesiccated) {
            if (player.m_21051_(Attributes.f_22279_).m_22111_(SPEED_MODIFIER_UUID) == null) {
                player.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(SPEED_MODIFIER_UUID, "Vampire speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        } else if (player.m_21051_(Attributes.f_22279_) != null) {
            Objects.requireNonNull(player.m_21051_(Attributes.f_22279_)).m_22120_(SPEED_MODIFIER_UUID);
        }
        if (isAnyVampire && player.m_21223_() > 1.0f && !isDesiccated) {
            VampireAttributeEvent.applyHiddenEffectIfMissing(player, MobEffects.f_19611_, -1, 106, false, false, false);
        } else if (!isAnyVampire && player.m_21124_(MobEffects.f_19611_) != null && (instance = player.m_21124_(MobEffects.f_19611_)).m_19564_() == 106 && instance.m_19557_() == -1) {
            player.m_21195_(MobEffects.f_19611_);
        }
        if (!(isAnyVampire && player.m_21223_() <= 1.0f && player.m_36324_().m_38702_() == 0 && !isDesiccated || isAnyVampire && player.m_36324_().m_38702_() == 0 && isDesiccated)) {
            player.m_21195_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get());
        }
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!SpeciesCheck.isAnyVampire(player)) {
                return;
            }
            if (!VariableManager.isBuffed((Entity)player) || player.m_21223_() <= 1.0f) {
                return;
            }
            player.m_20256_(player.m_20184_().m_82520_(0.0, 0.2, 0.0));
        }
    }

    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!SpeciesCheck.isAnyVampire(player)) {
                return;
            }
            if (!VariableManager.isBuffed((Entity)player) || player.m_21223_() <= 1.0f) {
                return;
            }
            event.setDistance(event.getDistance() - 1.5f);
        }
    }

    private static void applyDesiccationEffect(Player player, int duration) {
        MobEffectInstance currentEffect = player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get());
        if (currentEffect == null) {
            MobEffectInstance giveEffect = new MobEffectInstance((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get(), duration, 0, false, false, true);
            giveEffect.setCurativeItems(Collections.emptyList());
            player.m_7292_(giveEffect);
        }
    }

    private static void applyHiddenEffectIfMissing(Player player, MobEffect effect, int duration, int amplifier, boolean ambient, boolean showParticles, boolean visible) {
        MobEffectInstance currentEffect = player.m_21124_(effect);
        if (currentEffect == null || currentEffect.m_19557_() < duration - 1) {
            player.m_7292_(new MobEffectInstance(effect, duration, amplifier, ambient, showParticles, visible));
        }
    }
}

