/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.event.species.vampire;

import it.mitl.maleficium.config.MaleficiumCommonConfigs;
import it.mitl.maleficium.effect.ModEffects;
import it.mitl.maleficium.subroutine.SpeciesCheck;
import it.mitl.maleficium.subroutine.VariableManager;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium")
public class VampireDeathEvent {
    @SubscribeEvent
    public static void onVampireNearDeath(LivingDamageEvent event) {
        if (!((Boolean)MaleficiumCommonConfigs.NEAR_IMMORTAL_VAMPIRES.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!SpeciesCheck.isAnyVampire(player)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        float healthAfter = player.m_21223_() - event.getAmount();
        if (healthAfter < 1.0f) {
            if (VampireDeathEvent.meetsVampireDeathConditions(event)) {
                return;
            }
            if (serverPlayer.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null && event.getSource().m_276093_(DamageTypes.f_268441_)) {
                event.setCanceled(true);
                return;
            }
            player.m_21153_(1.0f);
            if (serverPlayer.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get()) != null) {
                MobEffectInstance desiccationEffect = serverPlayer.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get());
                int currentDuration = desiccationEffect.m_19557_();
                if (currentDuration > 300) {
                    int newDuration = Math.max(300, currentDuration - 100);
                    serverPlayer.m_36324_().m_38705_(1);
                    event.getEntity().m_21195_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get());
                    serverPlayer.m_36324_().m_38705_(0);
                    event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get(), newDuration, desiccationEffect.m_19564_(), false, false, true));
                }
                event.setCanceled(true);
                return;
            }
            int currentFood = player.m_36324_().m_38702_();
            if (currentFood > 0) {
                int newFood = currentFood - 2;
                if (newFood <= 0) {
                    player.m_36324_().m_38705_(0);
                    VampireDeathEvent.applyDesiccationEffect(serverPlayer, 1200);
                } else {
                    player.m_36324_().m_38705_(newFood);
                }
                event.setCanceled(true);
                return;
            }
            player.m_36324_().m_38705_(0);
            VampireDeathEvent.applyDesiccationEffect(serverPlayer, 1200);
            event.setCanceled(true);
        }
    }

    public static boolean meetsVampireDeathConditions(LivingDamageEvent event) {
        LivingEntity attacker;
        Entity entity;
        DamageSource source = event.getSource();
        String msgId = source.m_19385_();
        event.getEntity().m_213846_((Component)Component.m_237113_((String)("DamageSource msgId: " + msgId)));
        event.getEntity().m_213846_((Component)Component.m_237113_((String)("Damage Amount: " + event.getAmount())));
        Player player = (Player)event.getEntity();
        if (SpeciesCheck.isOriginalVampire(player)) {
            return msgId.equals("white_oak_stake_death") || msgId.equals("gave_up");
        }
        return event.getSource().m_276093_(DamageTypes.f_268631_) || event.getSource().m_276093_(DamageTypes.f_268468_) || event.getSource().m_276093_(DamageTypes.f_268546_) || event.getSource().m_276093_(DamageTypes.f_268724_) || (entity = event.getSource().m_7640_()) instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21205_().m_41720_() == Items.f_42420_ || msgId.equals("gave_up") || msgId.equals("white_oak_stake_death") || msgId.equals("vampire_original_death") || event.getAmount() == Float.MAX_VALUE;
    }

    @SubscribeEvent
    public static void onVampireDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SpeciesCheck.isAnyVampire(player = (Player)livingEntity)) {
            MinecraftServer server;
            if (SpeciesCheck.isOriginalVampire(player) && (server = player.m_20194_()) != null) {
                VariableManager.setSpecies("human", (Entity)player);
                server.m_6846_().m_11314_().forEach(p -> {
                    if (VariableManager.getOriginalVampire((Entity)p).equals(player.m_20148_().toString())) {
                        p.m_6074_();
                        p.m_213846_((Component)Component.m_237113_((String)"\u00a74Your original has been slain! You are no longer a Vampire."));
                        VariableManager.setSpecies("human", (Entity)player);
                        VariableManager.setOriginalVampire((Entity)p, "none");
                    }
                });
                server.m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)"\u00a74An Original has been slain! So too die all of its progeny.")));
            }
            VariableManager.setSpecies("human", (Entity)player);
            VariableManager.setOriginalVampire((Entity)player, "none");
            VariableManager.setExtraHunger(0, (Entity)player);
        }
    }

    private static void applyDesiccationEffect(ServerPlayer player, int duration) {
        MobEffectInstance currentEffect = player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get());
        MobEffectInstance desiccatedEffect = player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get());
        if (currentEffect == null && desiccatedEffect == null) {
            MobEffectInstance giveEffect = new MobEffectInstance((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get(), duration, 0, false, false, true);
            giveEffect.setCurativeItems(Collections.emptyList());
            player.m_7292_(giveEffect);
        }
    }
}

