/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.event.species.vampire;

import it.mitl.maleficium.effect.ModEffects;
import it.mitl.maleficium.network.ModMessages;
import it.mitl.maleficium.network.packet.DesiccationRenderS2CPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium")
public class VampireDesiccatedEvent {
    public static boolean isDesiccated(Player player) {
        return player.m_21023_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        for (ServerPlayer other : sp.m_20194_().m_6846_().m_11314_()) {
            if (!other.m_21023_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get())) continue;
            ModMessages.sendToClient(new DesiccationRenderS2CPacket(other.m_20148_(), true), sp);
        }
        if (sp.m_21023_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get())) {
            for (ServerPlayer other : sp.m_20194_().m_6846_().m_11314_()) {
                if (other == sp) continue;
                ModMessages.sendToClient(new DesiccationRenderS2CPacket(sp.m_20148_(), true), other);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (VampireDesiccatedEvent.isDesiccated(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && VampireDesiccatedEvent.isDesiccated(player = (Player)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        if (VampireDesiccatedEvent.isDesiccated(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemUseEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (VampireDesiccatedEvent.isDesiccated(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobTargetChange(LivingChangeTargetEvent event) {
        Player player;
        LivingEntity target = event.getNewTarget();
        if (target instanceof Player && (player = (Player)target).m_21023_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.m_19544_() == ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) {
                double radius = 32.0;
                for (Mob mob : entity.m_9236_().m_45976_(Mob.class, entity.m_20191_().m_82400_(radius))) {
                    if (mob.m_5448_() != player) continue;
                    mob.m_6710_(null);
                }
                if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    for (ServerPlayer p : sp.m_20194_().m_6846_().m_11314_()) {
                        ModMessages.sendToClient(new DesiccationRenderS2CPacket(player.m_20148_(), true), p);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getEffect() == ModEffects.VAMPIRE_DESICCATED_EFFECT.get() && !player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                for (ServerPlayer p : sp.m_20194_().m_6846_().m_11314_()) {
                    ModMessages.sendToClient(new DesiccationRenderS2CPacket(player.m_20148_(), false), p);
                }
            }
        }
    }
}

