/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.event.species.vampire;

import it.mitl.maleficium.subroutine.SpeciesCheck;
import it.mitl.maleficium.subroutine.VariableManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium")
public class VampireFoodEvent {
    @SubscribeEvent
    public static void onPlayerEatAttempt(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        if (!SpeciesCheck.isAnyVampire(player)) {
            return;
        }
        if (!itemStack.m_41614_()) {
            return;
        }
        event.setCanceled(true);
        player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't eat items anymore. How about blood?"), true);
    }

    @SubscribeEvent
    public static void onPlayerHungerDecreaseTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!SpeciesCheck.isAnyVampire(player)) {
            return;
        }
        if (player.m_36324_().m_38702_() < 20 && VariableManager.getExtraHunger((Entity)player) > 0) {
            int extraHunger = VariableManager.getExtraHunger((Entity)player);
            int foodLevel = player.m_36324_().m_38702_();
            int hungerToFill = Math.min(20 - foodLevel, extraHunger);
            player.m_36324_().m_38705_(foodLevel + hungerToFill);
            VariableManager.setExtraHunger(extraHunger - hungerToFill, (Entity)player);
        }
    }
}

