/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.event.species.vampire;

import it.mitl.maleficium.subroutine.SpeciesCheck;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium")
public class VampireUndeadIgnoreEvent {
    private static final Map<UUID, UUID> provokedMobs = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> lastHitTimestamps = new HashMap<UUID, Long>();
    private static final long PROVOKE_TIMEOUT = 15000L;

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_6336_() != MobType.f_21641_) {
            return;
        }
        if (mob instanceof WitherBoss) {
            return;
        }
        LivingEntity livingEntity2 = event.getNewTarget();
        if (!(livingEntity2 instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity2;
        if (SpeciesCheck.isAnyVampire(player)) {
            UUID provokedPlayer = provokedMobs.get(mob.m_20148_());
            if (provokedPlayer != null && provokedPlayer.equals(player.m_20148_())) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_6336_() != MobType.f_21641_) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpeciesCheck.isAnyVampire(player)) {
            UUID mobUUID = mob.m_20148_();
            provokedMobs.put(mobUUID, player.m_20148_());
            lastHitTimestamps.put(mobUUID, System.currentTimeMillis());
        }
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        if (provokedMobs.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            UUID mobUUID = mob.m_20148_();
            provokedMobs.remove(mobUUID);
            lastHitTimestamps.remove(mobUUID);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (provokedMobs.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Long>> iterator = lastHitTimestamps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            if (currentTime - entry.getValue() <= 15000L) continue;
            UUID mobUUID = entry.getKey();
            iterator.remove();
            provokedMobs.remove(mobUUID);
        }
    }
}

