/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.item.custom;

import it.mitl.maleficium.subroutine.PlayerUtils;
import it.mitl.maleficium.subroutine.SoundPlayer;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MoraMiseriumItem
extends Item {
    private static final String OWNER_TAG = "owner";
    private static final String DARK_MAGIC_TAG = "darkmagic";
    private static final int MAX_DARK_MAGIC = 100;

    public MoraMiseriumItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41503_(500).m_41486_());
    }

    public static void setOwner(ItemStack stack, String owner) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(OWNER_TAG, owner);
    }

    public static void setItemDarkMagic(ItemStack stack, int DarkMagic, int method) {
        int currentDarkMagic;
        CompoundTag tag = stack.m_41784_();
        int newDarkMagic = currentDarkMagic = tag.m_128451_(DARK_MAGIC_TAG);
        newDarkMagic = switch (method) {
            case 0 -> DarkMagic;
            case 1 -> Math.min(100, currentDarkMagic + DarkMagic);
            case 2 -> Math.max(0, currentDarkMagic - DarkMagic);
            default -> newDarkMagic;
        };
        tag.m_128405_(DARK_MAGIC_TAG, newDarkMagic);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6047_() && !tag.m_128441_(OWNER_TAG)) {
            MoraMiseriumItem.setOwner(stack, player.m_7755_().getString());
            MoraMiseriumItem.setItemDarkMagic(stack, 0, 2);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a75This Mora Miserium is now bound to you."), true);
            SoundPlayer.playXpSound(player);
        } else if (player.m_6047_() && tag.m_128441_(OWNER_TAG) && tag.m_128461_(OWNER_TAG).equals(player.m_7755_().getString()) && PlayerUtils.getDarkMagic((ServerPlayer)player) != -1) {
            if (tag.m_128451_(DARK_MAGIC_TAG) >= 100) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cThis Mora Miserium is already full of \u00a75dark magic."), true);
                SoundPlayer.playXpSound(player);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a75You have stored some dark magic in the Mora Miserium."), true);
            SoundPlayer.playXpSound(player);
            PlayerUtils.setDarkMagic((ServerPlayer)player, 1, 2);
            MoraMiseriumItem.setItemDarkMagic(stack, 1, 1);
        } else if (player.m_6047_() && tag.m_128441_(OWNER_TAG) && tag.m_128461_(OWNER_TAG).equals(player.m_7755_().getString()) && PlayerUtils.getDarkMagic((ServerPlayer)player) == -1) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cYou have no \u00a75dark magic\u00a7c to store in the Mora Miserium."), true);
            SoundPlayer.playXpSound(player);
        } else if (!tag.m_128441_(OWNER_TAG) || !tag.m_128461_(OWNER_TAG).equals(player.m_7755_().getString())) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cThis Mora Miserium is not bound to you."), true);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7oUsed to hold \u00a75dark magic"));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(OWNER_TAG)) {
            String owner = tag.m_128461_(OWNER_TAG);
            tooltip.add((Component)Component.m_237113_((String)("\u00a78Owner: " + owner)));
        }
        if (tag != null && tag.m_128441_(DARK_MAGIC_TAG)) {
            int darkMagic = tag.m_128451_(DARK_MAGIC_TAG);
            tooltip.add((Component)Component.m_237113_((String)("\u00a75Dark Magic: " + darkMagic + "/100")));
        }
    }
}

