/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.network.packet;

import it.mitl.maleficium.client.state.ClientDesiccationState;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class DesiccationRenderS2CPacket {
    private final UUID playerId;
    private final boolean desiccated;

    public DesiccationRenderS2CPacket(UUID playerId, boolean desiccated) {
        this.playerId = playerId;
        this.desiccated = desiccated;
    }

    public DesiccationRenderS2CPacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.desiccated = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.writeBoolean(this.desiccated);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Player ent;
            ClientDesiccationState.set(this.playerId, this.desiccated);
            if (Minecraft.m_91087_().f_91073_ == null || (ent = Minecraft.m_91087_().f_91073_.m_46003_(this.playerId)) != null) {
                // empty if block
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

