/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.network.packet;

import it.mitl.maleficium.network.serverhandler.VampireRequests;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class FeedBloodC2SPacket {
    private final UUID entityUUID;

    public FeedBloodC2SPacket(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public FeedBloodC2SPacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            VampireRequests.handleFeedBloodRequest(player, this.entityUUID);
        });
        context.setPacketHandled(true);
    }
}

