/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.network.packet;

import it.mitl.maleficium.network.serverhandler.VampireRequests;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class VillagerDiscountC2SPacket {
    private final UUID villagerUUID;

    public VillagerDiscountC2SPacket(UUID villagerUUID) {
        this.villagerUUID = villagerUUID;
    }

    public VillagerDiscountC2SPacket(FriendlyByteBuf buf) {
        this.villagerUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.villagerUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            VampireRequests.handleDiscountRequest(player, this.villagerUUID);
        });
        context.setPacketHandled(true);
    }
}

