/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.network.serverhandler;

import it.mitl.maleficium.capability.blood.BloodCapability;
import it.mitl.maleficium.effect.ModEffects;
import it.mitl.maleficium.subroutine.FollowEntityGoal;
import it.mitl.maleficium.subroutine.PlayerUtils;
import it.mitl.maleficium.subroutine.SoundPlayer;
import it.mitl.maleficium.subroutine.SpeciesCheck;
import it.mitl.maleficium.subroutine.VariableManager;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VampireRequests {
    public static void handleGiveUpRequest(ServerPlayer player) {
        if (!SpeciesCheck.isAnyVampire((Player)player)) {
            return;
        }
        if (player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null) {
            Level world = player.m_9236_();
            player.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("maleficium:gave_up")))), Float.MAX_VALUE);
        }
    }

    public static void handleFeedBloodRequest(ServerPlayer player, UUID entityUUID) {
        Entity entity = player.m_284548_().m_8791_(entityUUID);
        Player targetPlayer = null;
        if (entity instanceof Player) {
            targetPlayer = (Player)entity;
        } else if (entity instanceof LivingEntity) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can only feed your blood to players!"), true);
            return;
        }
        if (!SpeciesCheck.isAnyVampire((Player)player) && targetPlayer.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null && player.m_21223_() > 1.0f) {
            targetPlayer.m_36324_().m_38705_(6);
            targetPlayer.m_21195_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get());
            player.m_6469_(player.m_269291_().m_269425_(), 1.0f);
            return;
        }
        if (!SpeciesCheck.isAnyVampire((Player)player) && targetPlayer.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null && player.m_21223_() <= 1.0f) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You are too weak to feed your blood to this player!"), true);
            return;
        }
        if (!SpeciesCheck.isAnyVampire((Player)player)) {
            return;
        }
        if (player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get()) != null || player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't feed players while desiccated!"), true);
            return;
        }
        if (targetPlayer.m_21124_((MobEffect)ModEffects.VAMPIRE_BLOOD_EFFECT.get()) != null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74This player already has vampire blood in their system!"), true);
            return;
        }
        if (SpeciesCheck.isAnyVampire(targetPlayer)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't feed your blood to another vampire!"), true);
            return;
        }
        targetPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2, true, false));
        MobEffectInstance vampireBloodEffectInstance = new MobEffectInstance((MobEffect)ModEffects.VAMPIRE_BLOOD_EFFECT.get(), 18000, 0, false, false, true);
        vampireBloodEffectInstance.setCurativeItems(Collections.emptyList());
        targetPlayer.m_7292_(vampireBloodEffectInstance);
        String originalVampireUUID = null;
        if (SpeciesCheck.isOriginalVampire((Player)player)) {
            originalVampireUUID = player.m_20148_().toString();
        } else if (SpeciesCheck.isOnlyVampire((Player)player)) {
            originalVampireUUID = VariableManager.getOriginalVampire((Entity)player);
        }
        VariableManager.setOriginalVampire((Entity)targetPlayer, originalVampireUUID);
    }

    public static void handleFastTravelRequest(ServerPlayer player) {
        if (!SpeciesCheck.isAnyVampire((Player)player)) {
            return;
        }
        boolean isOriginalVampire = SpeciesCheck.isOriginalVampire((Player)player);
        if (player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get()) != null || player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't fast travel while desiccated!"), true);
            return;
        }
        FoodData foodData = player.m_36324_();
        if (foodData.m_38702_() < 8) {
            if (!isOriginalVampire) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You are too hungry to use this ability!"), true);
                return;
            }
            if (isOriginalVampire && foodData.m_38702_() < 4) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You are too hungry to use this ability!"), true);
                return;
            }
        }
        if (player.m_21255_() || PlayerUtils.isPlayerFalling(player) || player.m_20069_() || player.m_20077_() || player.m_20159_() || player.m_20160_() || player.m_5803_() || player.m_5833_() || player.m_6060_() || player.f_146808_ || PlayerUtils.isPlayerOnSoulSand(player)) {
            Object message = "\u00a74You can't use this ability while ";
            if (PlayerUtils.isPlayerOnSoulSand(player)) {
                message = (String)message + "on soul sand!";
            } else if (player.m_21255_() || PlayerUtils.isPlayerFalling(player)) {
                message = (String)message + "falling!";
            } else if (player.m_20069_() || player.m_20077_()) {
                message = (String)message + "in water or lava!";
            } else if (player.m_20159_() || player.m_20160_()) {
                message = (String)message + "riding an entity!";
            } else if (player.m_5803_()) {
                message = (String)message + "sleeping!";
            } else if (player.m_5833_()) {
                message = (String)message + "in spectator mode!";
            } else if (player.m_6060_()) {
                message = (String)message + "on fire!";
            } else if (player.f_146808_) {
                message = (String)message + "in powder snow!";
            }
            player.m_5661_((Component)Component.m_237113_((String)message), true);
            return;
        }
        Vec3 eyePosition = player.m_146892_();
        Vec3 lookVector = player.m_20252_(1.0f).m_82490_(100.0);
        BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(eyePosition, eyePosition.m_82549_(lookVector), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 targetPosition = hitResult.m_82450_();
            Vec3 startPosition = player.m_20182_();
            double distance = startPosition.m_82554_(targetPosition);
            int particleCount = (int)(distance * 10.0);
            for (int i = 0; i <= particleCount; ++i) {
                double progress = (double)i / (double)particleCount;
                double x = startPosition.f_82479_ + (targetPosition.f_82479_ - startPosition.f_82479_) * progress;
                double y = startPosition.f_82480_ + (targetPosition.f_82480_ - startPosition.f_82480_) * progress;
                double z = startPosition.f_82481_ + (targetPosition.f_82481_ - startPosition.f_82481_) * progress;
                Level level = player.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            player.m_6021_(targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_());
            int foodReductionValue = isOriginalVampire ? 4 : 8;
            foodData.m_38705_(foodData.m_38702_() - foodReductionValue);
        }
    }

    public static void handleDiscountRequest(ServerPlayer player, UUID villagerUUID) {
        Level world = player.m_9236_();
        Entity entity = ((ServerLevel)world).m_8791_(villagerUUID);
        if (entity instanceof Villager) {
            FoodData foodData;
            Villager villager = (Villager)entity;
            if (!SpeciesCheck.isAnyVampire((Player)player)) {
                return;
            }
            boolean isOriginalVampire = SpeciesCheck.isOriginalVampire((Player)player);
            if (player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get()) != null || player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't compel mobs while desiccated!"), true);
            }
            if ((foodData = player.m_36324_()).m_38702_() < 4 && !isOriginalVampire) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You are too hungry to compel this villager!"), true);
                return;
            }
            boolean discountApplied = false;
            for (MerchantOffer offer : villager.m_6616_()) {
                int originalCost = offer.m_45358_().m_41613_();
                int maxDiscount = -originalCost / 2;
                int currentDiscount = offer.m_45377_();
                if (currentDiscount <= maxDiscount) continue;
                offer.m_45359_(currentDiscount - originalCost / 2);
                if (offer.m_45377_() < maxDiscount) {
                    offer.m_45359_(maxDiscount);
                }
                discountApplied = true;
            }
            if (discountApplied) {
                int foodReductionValue = isOriginalVampire ? 2 : 4;
                foodData.m_38705_(foodData.m_38702_() - foodReductionValue);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You have compelled the villager!"), true);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You have already compelled this villager!"), true);
            }
        }
    }

    public static void handleCompelRequest(ServerPlayer player, UUID entityUUID) {
        boolean isOriginalVampire;
        ServerLevel level = player.m_284548_();
        Entity entity = level.m_8791_(entityUUID);
        if (!"vampire".equals(VariableManager.getSpecies((Entity)player))) {
            return;
        }
        if (player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATION_EFFECT.get()) != null || player.m_21124_((MobEffect)ModEffects.VAMPIRE_DESICCATED_EFFECT.get()) != null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't compel mobs while desiccated!"), true);
        }
        int foodReductionValue = (isOriginalVampire = SpeciesCheck.isOriginalVampire((Player)player)) ? 2 : 4;
        FoodData foodData = player.m_36324_();
        if (foodData.m_38702_() < 4 && !isOriginalVampire) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You are too hungry to compel this mob!"), true);
            return;
        }
        if (entity instanceof Mob) {
            long existingFollowUntil;
            Mob mob = (Mob)entity;
            long gameTime = level.m_46467_();
            int followSeconds = isOriginalVampire ? 30 : 15;
            long followUntil = mob.m_9236_().m_46467_() + (long)(20 * followSeconds);
            if (mob.getPersistentData().m_128441_("FollowUntil") && (existingFollowUntil = mob.getPersistentData().m_128454_("FollowUntil")) > gameTime) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74This mob is already compelled to follow you!"), true);
                return;
            }
            mob.getPersistentData().m_128356_("FollowUntil", followUntil);
            FollowEntityGoal followGoal = new FollowEntityGoal(mob, (Player)player, 1.2, 2.0f);
            mob.f_21345_.m_25352_(1, (Goal)followGoal);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a74You have compelled this mob to follow you! (" + followSeconds + " secs)")), true);
            player.m_36324_().m_38705_(player.m_36324_().m_38702_() - foodReductionValue);
        }
    }

    public static void handleBloodSuckRequest(ServerPlayer player, UUID entityUUID) {
        Player entityPlayer;
        LivingEntity livingEntity;
        Level world = player.m_9236_();
        Entity entity = ((ServerLevel)world).m_8791_(entityUUID);
        if (!SpeciesCheck.isAnyVampire((Player)player) && player.m_21124_((MobEffect)ModEffects.VAMPIRIC_TRANSITION_EFFECT.get()) == null) {
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21233_() > 40.0f) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't suck blood from this mob!"), true);
            return;
        }
        if (entity instanceof Player && SpeciesCheck.isAnyVampire(entityPlayer = (Player)entity)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't suck blood from another vampire!"), true);
            return;
        }
        if (entity instanceof Player && (entityPlayer = (Player)entity).m_21124_((MobEffect)ModEffects.VAMPIRIC_TRANSITION_EFFECT.get()) != null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't suck blood from a player in transition!"), true);
            return;
        }
        if (entity instanceof Player && ((entityPlayer = (Player)entity).m_7500_() || entityPlayer.m_5833_())) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a74You can't suck blood from a player in creative!"), true);
            return;
        }
        if (player.m_21124_((MobEffect)ModEffects.VAMPIRIC_TRANSITION_EFFECT.get()) != null) {
            player.m_21195_((MobEffect)ModEffects.VAMPIRIC_TRANSITION_EFFECT.get());
            VariableManager.setSpecies("vampire", (Entity)player);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12563_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_21219_();
            player.m_21153_(30.0f);
            player.m_36324_().m_38705_(20);
            SoundPlayer.playBloodSuckSound((Player)player);
        }
        if (entity instanceof ServerPlayer) {
            Advancement firstBloodAdvancement;
            ServerPlayer playerTarget = (ServerPlayer)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                livingEntity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 255, true, false));
            }
            if (playerTarget.m_21223_() <= 1.0f) {
                playerTarget.m_6469_(player.m_269291_().m_269425_(), 1.0f);
                PlayerUtils.addHungerForVampire(2.0f, player);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2, true, false));
                player.m_5661_((Component)Component.m_237113_((String)"\u00a74You drained the player to death!"), true);
                SoundPlayer.playBloodSuckSound((Player)player);
                firstBloodAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "first_blood"));
                Advancement aFulfillingMealAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "a_fulfilling_meal"));
                Advancement isItCannibalismAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "is_it_cannibalism"));
                player.m_8960_().m_135988_(firstBloodAdvancement, "first_blood");
                player.m_8960_().m_135988_(aFulfillingMealAdvancement, "a_fulfilling_meal");
                player.m_8960_().m_135988_(isItCannibalismAdvancement, "is_it_cannibalism");
                return;
            }
            firstBloodAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "first_blood"));
            Advancement isItCannibalismAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "is_it_cannibalism"));
            player.m_8960_().m_135988_(firstBloodAdvancement, "first_blood");
            player.m_8960_().m_135988_(isItCannibalismAdvancement, "is_it_cannibalism");
            playerTarget.m_6469_(player.m_269291_().m_269425_(), 1.0f);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a74You have sucked blood from " + playerTarget.m_7755_().getString() + "! (" + (int)playerTarget.m_21223_() + "/" + (int)playerTarget.m_21233_() + ")")), true);
            PlayerUtils.addHungerForVampire(2.0f, player);
            SoundPlayer.playBloodSuckSound((Player)player);
            return;
        }
        BloodCapability.getBloodCapability(entity).ifPresent(blood -> {
            Level patt20353$temp;
            float currentBlood = blood.getBlood();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 255, true, false));
            }
            if ((patt20353$temp = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt20353$temp;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 20, 0.3, 0.5, 0.3, 0.1);
            }
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                if (currentBlood <= 2.0f) {
                    entity.m_6074_();
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2, true, false));
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a74You drained the villager to death!"), true);
                    aFulfillingMealAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "a_fulfilling_meal"));
                    Advancement enemyOfTheVillageAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "enemy_of_the_village"));
                    player.m_8960_().m_135988_(aFulfillingMealAdvancement, "a_fulfilling_meal");
                    player.m_8960_().m_135988_(enemyOfTheVillageAdvancement, "enemy_of_the_village");
                    SoundPlayer.playBloodSuckSound((Player)player);
                    AABB searchArea = new AABB(villager.m_20183_()).m_82400_(25.0);
                    player.m_9236_().m_6443_(IronGolem.class, searchArea, golem -> golem.m_6084_()).forEach(golem -> golem.m_6710_((LivingEntity)player));
                    PlayerUtils.addHungerForVampire(currentBlood, player);
                    return;
                }
                blood.setBlood(currentBlood - 2.0f);
                PlayerUtils.addHungerForVampire(1.0f, player);
                player.m_36324_().m_38717_(player.m_36324_().m_38722_() + 1.0f);
            } else {
                if (currentBlood == 1.0f) {
                    entity.m_6074_();
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2, true, false));
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a74You drained the mob to death!"), true);
                    aFulfillingMealAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "a_fulfilling_meal"));
                    player.m_8960_().m_135988_(aFulfillingMealAdvancement, "a_fulfilling_meal");
                    PlayerUtils.addHungerForVampire(1.0f, player);
                    SoundPlayer.playBloodSuckSound((Player)player);
                    return;
                }
                blood.setBlood(currentBlood - 1.0f);
            }
            float newBlood = blood.getBlood();
            if (player.m_36324_().m_38702_() < 40) {
                PlayerUtils.addHungerForVampire(1.0f, player);
            }
            int newBloodInt = (int)newBlood;
            int maxBloodInt = (int)blood.getMaxBlood();
            player.m_5661_((Component)Component.m_237113_((String)("\u00a74You have sucked blood from this mob! (" + newBloodInt + "/" + maxBloodInt + ")")), true);
            Advancement firstBloodAdvancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("maleficium", "first_blood"));
            player.m_8960_().m_135988_(firstBloodAdvancement, "first_blood");
            SoundPlayer.playBloodSuckSound((Player)player);
        });
    }

    public static void handleBuffToggleRequest(ServerPlayer player) {
        if (!SpeciesCheck.isAnyVampire((Player)player) && !SpeciesCheck.isWerewolf((Player)player)) {
            return;
        }
        VariableManager.setBuffed(!VariableManager.isBuffed((Entity)player), (Entity)player);
        if (VariableManager.isBuffed((Entity)player)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7aYour movement buffs are now enabled."), true);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cYour movement buffs are now disabled."), true);
        }
    }
}

