/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.subroutine;

import it.mitl.maleficium.subroutine.FollowEntityGoal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="maleficium")
public class CompelManager {
    public static final Map<UUID, FollowEntityGoal> compelGoals = new HashMap<UUID, FollowEntityGoal>();
    public static final Map<UUID, Integer> compelTimers = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<UUID, Integer>> iter = compelTimers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UUID, Integer> entry = iter.next();
            UUID uuid = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                for (ServerLevel level : server.m_129785_()) {
                    Entity e = level.m_8791_(uuid);
                    if (!(e instanceof Mob)) continue;
                    Mob mob = (Mob)e;
                    FollowEntityGoal goal = compelGoals.get(uuid);
                    if (goal == null) continue;
                    mob.f_21345_.m_25363_((Goal)goal);
                }
                compelGoals.remove(uuid);
                iter.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
    }
}

