/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.maleficium.subroutine.spell;

import it.mitl.maleficium.block.ModBlocks;
import it.mitl.maleficium.effect.ModEffects;
import it.mitl.maleficium.item.ModItems;
import it.mitl.maleficium.item.custom.BloodBottleItem;
import it.mitl.maleficium.subroutine.PlayerUtils;
import it.mitl.maleficium.subroutine.SpeciesCheck;
import it.mitl.maleficium.subroutine.VariableManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maleficium")
public class VampireCreation {
    @SubscribeEvent
    public static void onDogDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Wolf) {
            Wolf dog = (Wolf)livingEntity;
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (!dog.m_21824_() || dog.m_269323_() != player || !SpeciesCheck.isWitch((Player)player)) {
                    return;
                }
                Level level = dog.m_9236_();
                if (level.m_46461_() || level.m_46941_() != 0) {
                    return;
                }
                int logCount = 0;
                int leafCount = 0;
                BlockPos deathPos = dog.m_20183_();
                for (int x = -5; x <= 5; ++x) {
                    for (int y = -5; y <= 5; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos checkPos = deathPos.m_7918_(x, y, z);
                            BlockState state = level.m_8055_(checkPos);
                            if (state.m_60734_() == ModBlocks.WHITE_OAK_LOG.get()) {
                                ++logCount;
                            }
                            if (state.m_60734_() != ModBlocks.WHITE_OAK_LEAVES.get()) continue;
                            ++leafCount;
                        }
                    }
                }
                if (logCount < 3 || leafCount < 3) {
                    return;
                }
                int glowstoneNeeded = 3;
                int sunflowerNeeded = 3;
                int bloodBottleNeeded = 1;
                List itemEntities = level.m_45976_(ItemEntity.class, dog.m_20191_().m_82400_(5.0));
                for (ItemEntity itemEntity : itemEntities) {
                    String bloodEntity;
                    int remove;
                    ItemStack stack = itemEntity.m_32055_();
                    if (glowstoneNeeded > 0 && stack.m_41720_() == Items.f_42525_) {
                        remove = Math.min(stack.m_41613_(), glowstoneNeeded);
                        glowstoneNeeded -= remove;
                        stack.m_41774_(remove);
                        if (stack.m_41619_()) {
                            itemEntity.m_146870_();
                        }
                    }
                    if (sunflowerNeeded > 0 && stack.m_41720_() == ModItems.CRUSHED_SUNFLOWER.get()) {
                        remove = Math.min(stack.m_41613_(), sunflowerNeeded);
                        sunflowerNeeded -= remove;
                        stack.m_41774_(remove);
                        if (stack.m_41619_()) {
                            itemEntity.m_146870_();
                        }
                    }
                    if (bloodBottleNeeded > 0 && stack.m_41720_() == ModItems.BLOOD_BOTTLE.get() && (bloodEntity = BloodBottleItem.getBloodEntity(stack)).equals(EntityType.f_20492_.toString())) {
                        int remove2 = Math.min(stack.m_41613_(), bloodBottleNeeded);
                        bloodBottleNeeded -= remove2;
                        stack.m_41774_(remove2);
                        for (int i = 0; i < remove2; ++i) {
                            ItemEntity glassBottle = new ItemEntity(level, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), new ItemStack((ItemLike)Items.f_42590_));
                            level.m_7967_((Entity)glassBottle);
                        }
                        if (stack.m_41619_()) {
                            itemEntity.m_146870_();
                        }
                    }
                    if (glowstoneNeeded != 0 || sunflowerNeeded != 0 || bloodBottleNeeded != 0) continue;
                    break;
                }
                if (glowstoneNeeded > 0 || sunflowerNeeded > 0 || bloodBottleNeeded > 0) {
                    return;
                }
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7aYou have activated the vampire creation ritual."), true);
                PlayerUtils.setDarkMagic(player, 1, 1);
                VariableManager.setKarma((Entity)player, VariableManager.getKarma((Entity)player) - 50);
                level.m_6907_().forEach(p -> {
                    if (p.m_20280_((Entity)dog) <= 225.0) {
                        MobEffectInstance giveEffect = new MobEffectInstance((MobEffect)ModEffects.ORIGINAL_VAMPIRE_TRANSITION_EFFECT.get(), 12000, 0, false, false, true);
                        giveEffect.setCurativeItems(Collections.emptyList());
                        p.m_7292_(giveEffect);
                        p.m_5661_((Component)Component.m_237113_((String)"\u00a7aYou are now in vampiric transition. Die to complete the process."), true);
                    }
                });
            }
        }
    }
}

