/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.crafttweaker.actions;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.xiaoyu.more_world_crafting.compat.crafttweaker.actions.BaseRecipeAction;
import com.xiaoyu.more_world_crafting.crafting.CrushingConversionManager;
import com.xiaoyu.more_world_crafting.recipe.CrushingConversionRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AddCrushingConversionRecipeAction
extends BaseRecipeAction {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final int minHeight;
    private final float conversionChance;
    private final String gravityType;

    public AddCrushingConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float conversionChance, int minHeight, String gravityType) {
        this.recipeId = recipeId;
        this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient.getInternal()});
        this.result = result.getInternal().m_41777_();
        this.conversionChance = conversionChance;
        this.minHeight = minHeight;
        this.gravityType = gravityType;
    }

    public AddCrushingConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float conversionChance) {
        this(recipeId, ingredient, result, conversionChance, 3, "minecraft:anvil");
    }

    @Override
    public void apply() {
        CrushingConversionRecipe recipe = new CrushingConversionRecipe(this.recipeId, this.ingredient, this.result, this.minHeight, this.conversionChance, this.gravityType);
        CrushingConversionManager.addCustomRecipe(recipe);
    }

    @Override
    public String describe() {
        return String.format("Adding Crushing Conversion recipe with id %s: %s -> %s (chance: %.2f, height: %d, gravity: %s)", this.recipeId, this.ingredient.m_43942_(), this.result.toString(), Float.valueOf(this.conversionChance), this.minHeight, this.gravityType);
    }

    @Override
    public void undo() {
        CrushingConversionManager.removeCustomRecipe(this.recipeId);
    }

    @Override
    public String describeUndo() {
        return String.format("Removing Crushing Conversion recipe with id %s", this.recipeId);
    }
}

