/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.crafttweaker.actions;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.xiaoyu.more_world_crafting.compat.crafttweaker.actions.BaseRecipeAction;
import com.xiaoyu.more_world_crafting.crafting.FireConversionManager;
import com.xiaoyu.more_world_crafting.recipe.FireConversionRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AddFireConversionRecipeAction
extends BaseRecipeAction {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float successChance;
    private final FireConversionRecipe.FireType fireType;
    private final String fireTypeString;

    public AddFireConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float successChance, String fireType) {
        this.recipeId = recipeId;
        this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient.getInternal()});
        this.result = result.getInternal().m_41777_();
        this.successChance = successChance;
        this.fireTypeString = fireType;
        this.fireType = FireConversionRecipe.FireType.fromItemId(fireType);
    }

    @Override
    public void apply() {
        FireConversionRecipe recipe = new FireConversionRecipe(this.recipeId, this.ingredient, this.result, this.successChance, this.fireType);
        FireConversionManager.addCustomRecipe(recipe);
    }

    @Override
    public String describe() {
        return String.format("Adding Fire Conversion recipe with id %s: %s -> %s (chance: %.2f, fire: %s)", this.recipeId, this.ingredient.m_43942_(), this.result.toString(), Float.valueOf(this.successChance), this.fireTypeString);
    }

    @Override
    public void undo() {
        FireConversionManager.removeCustomRecipe(this.recipeId);
    }

    @Override
    public String describeUndo() {
        return String.format("Removing Fire Conversion recipe with id %s", this.recipeId);
    }
}

