/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.crafttweaker.actions;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.xiaoyu.more_world_crafting.compat.crafttweaker.actions.BaseRecipeAction;
import com.xiaoyu.more_world_crafting.crafting.FluidConversionManager;
import com.xiaoyu.more_world_crafting.recipe.FluidConversionRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class AddFluidConversionRecipeAction
extends BaseRecipeAction {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float successChance;
    private final Fluid requiredFluid;
    private final String fluidName;

    public AddFluidConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float successChance, String requiredFluid) {
        this.recipeId = recipeId;
        this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient.getInternal()});
        this.result = result.getInternal().m_41777_();
        this.successChance = successChance;
        this.fluidName = requiredFluid;
        this.requiredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(requiredFluid));
        if (this.requiredFluid == null) {
            throw new IllegalArgumentException("Unknown fluid: " + requiredFluid);
        }
    }

    @Override
    public void apply() {
        FluidConversionRecipe recipe = new FluidConversionRecipe(this.recipeId, this.ingredient, this.result, this.successChance, this.requiredFluid);
        FluidConversionManager.addCustomRecipe(recipe);
    }

    @Override
    public String describe() {
        return String.format("Adding Fluid Conversion recipe with id %s: %s -> %s (chance: %.2f, fluid: %s)", this.recipeId, this.ingredient.m_43942_(), this.result.toString(), Float.valueOf(this.successChance), this.fluidName);
    }

    @Override
    public void undo() {
        FluidConversionManager.removeCustomRecipe(this.recipeId);
    }

    @Override
    public String describeUndo() {
        return String.format("Removing Fluid Conversion recipe with id %s", this.recipeId);
    }
}

