/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.crafttweaker.actions;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.xiaoyu.more_world_crafting.compat.crafttweaker.actions.BaseRecipeAction;
import com.xiaoyu.more_world_crafting.crafting.LightningConversionManager;
import com.xiaoyu.more_world_crafting.recipe.LightningConversionRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AddLightningConversionRecipeAction
extends BaseRecipeAction {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float lightningChance;
    private final float conversionChance;
    private final String weatherId;

    public AddLightningConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float conversionChance, float lightningChance, String weatherId) {
        this.recipeId = recipeId;
        this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient.getInternal()});
        this.result = result.getInternal().m_41777_();
        this.conversionChance = conversionChance;
        this.lightningChance = lightningChance;
        this.weatherId = weatherId != null ? weatherId : "";
    }

    public AddLightningConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float conversionChance, float lightningChance) {
        this(recipeId, ingredient, result, conversionChance, lightningChance, "");
    }

    public AddLightningConversionRecipeAction(ResourceLocation recipeId, IItemStack ingredient, IItemStack result, float conversionChance) {
        this(recipeId, ingredient, result, conversionChance, 0.1f, "");
    }

    @Override
    public void apply() {
        LightningConversionRecipe recipe = new LightningConversionRecipe(this.recipeId, this.ingredient, this.result, this.lightningChance, this.conversionChance, this.weatherId);
        LightningConversionManager.addCustomRecipe(recipe);
    }

    @Override
    public String describe() {
        return String.format("Adding Lightning Conversion recipe with id %s: %s -> %s (conversion: %.2f, lightning: %.2f, weather: %s)", this.recipeId, this.ingredient.m_43942_(), this.result.toString(), Float.valueOf(this.conversionChance), Float.valueOf(this.lightningChance), this.weatherId);
    }

    @Override
    public void undo() {
        LightningConversionManager.removeCustomRecipe(this.recipeId);
    }

    @Override
    public String describeUndo() {
        return String.format("Removing Lightning Conversion recipe with id %s", this.recipeId);
    }
}

