/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.jei.api;

import com.xiaoyu.more_world_crafting.compat.jei.api.IMultiIconProvider;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MultiIconProvider
implements IMultiIconProvider {
    private final List<IDrawable> icons;
    private final boolean alternating;
    private final int alternatingInterval;

    private MultiIconProvider(List<IDrawable> icons, boolean alternating, int alternatingInterval) {
        this.icons = new ArrayList<IDrawable>(icons);
        this.alternating = alternating;
        this.alternatingInterval = alternatingInterval;
    }

    @Override
    public List<IDrawable> getIcons() {
        return new ArrayList<IDrawable>(this.icons);
    }

    @Override
    public IDrawable getCurrentIcon(long tickCount) {
        if (this.icons.isEmpty()) {
            return null;
        }
        if (!this.alternating || this.icons.size() == 1) {
            return this.icons.get(0);
        }
        int index = (int)(tickCount / (long)this.alternatingInterval % (long)this.icons.size());
        return this.icons.get(index);
    }

    @Override
    public boolean isAlternating() {
        return this.alternating;
    }

    @Override
    public int getAlternatingInterval() {
        return this.alternatingInterval;
    }

    public static class Builder {
        private final List<IDrawable> icons = new ArrayList<IDrawable>();
        private final IGuiHelper guiHelper;
        private boolean alternating = true;
        private int alternatingInterval = 30;

        public Builder(IGuiHelper guiHelper) {
            this.guiHelper = guiHelper;
        }

        public Builder addItemIcon(ItemStack itemStack) {
            this.icons.add(this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStack));
            return this;
        }

        public Builder addFluidIcon(FluidStack fluidStack) {
            this.icons.add(this.guiHelper.createDrawableIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluidStack));
            return this;
        }

        public Builder setAlternating(boolean alternating) {
            this.alternating = alternating;
            return this;
        }

        public Builder setAlternatingInterval(int intervalTicks) {
            this.alternatingInterval = intervalTicks;
            return this;
        }

        public MultiIconProvider build() {
            if (this.icons.isEmpty()) {
                throw new IllegalStateException("At least one icon needs to be added.");
            }
            return new MultiIconProvider(this.icons, this.alternating, this.alternatingInterval);
        }
    }
}

