/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.jei.category;

import com.xiaoyu.more_world_crafting.compat.jei.api.JEIDrawHelper;
import com.xiaoyu.more_world_crafting.recipe.CrushingConversionRecipe;
import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CrushingConversionCategory
implements IRecipeCategory<CrushingConversionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("more_world_crafting", "crushing_conversion");
    public static final RecipeType<CrushingConversionRecipe> CRUSHING_CONVERSION_TYPE = new RecipeType(UID, CrushingConversionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final JEIDrawHelper drawHelper;
    private final IGuiHelper guiHelper;

    public CrushingConversionCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(150, 70);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42146_));
        this.drawHelper = new JEIDrawHelper(helper);
        this.guiHelper = helper;
    }

    public RecipeType<CrushingConversionRecipe> getRecipeType() {
        return CRUSHING_CONVERSION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.more_world_crafting.crushing_conversion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrushingConversionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 15).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getIngredient().m_43908_()));
        ItemStack gravityBlockItem = this.getGravityBlockItem(recipe.getGravityType());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 46, 15).addItemStack(gravityBlockItem)).setSlotName("gravity_block");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 15).addItemStack(recipe.m_8043_(null));
    }

    public void draw(CrushingConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.drawHelper.drawSlot(guiGraphics, 9, 14);
        this.drawHelper.drawSlot(guiGraphics, 45, 14);
        this.drawHelper.drawSlot(guiGraphics, 115, 14);
        this.drawHelper.drawArrow(guiGraphics, 75, 17);
        MutableComponent downText = Component.m_237113_((String)"\u2193");
        int downTextX = 55 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)downText) / 2;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)downText, downTextX, 35, 0x666666, false);
        int minHeight = recipe.getMinHeight();
        MutableComponent heightText = Component.m_237110_((String)"jei.more_world_crafting.min_height", (Object[])new Object[]{minHeight});
        int heightTextX = 8;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)heightText, heightTextX, 48, 0x404040, false);
        float conversionChance = recipe.getConversionChance();
        int conversionPercentage = Math.round(conversionChance * 100.0f);
        MutableComponent chanceText = Component.m_237110_((String)"jei.more_world_crafting.conversion_chance", (Object[])new Object[]{conversionPercentage + "%"});
        int chanceTextX = 8;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)chanceText, chanceTextX, 58, 0x404040, false);
    }

    private ItemStack getGravityBlockItem(String gravityType) {
        try {
            ResourceLocation itemId = new ResourceLocation(gravityType);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item != null && item != Items.f_41852_) {
                return new ItemStack((ItemLike)item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ItemStack((ItemLike)Items.f_41830_);
    }
}

