/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.jei.category;

import com.xiaoyu.more_world_crafting.compat.jei.api.IMultiIconProvider;
import com.xiaoyu.more_world_crafting.compat.jei.api.JEIDrawHelper;
import com.xiaoyu.more_world_crafting.compat.jei.api.JEIMultiIconUtils;
import com.xiaoyu.more_world_crafting.compat.jei.api.MultiIconProvider;
import com.xiaoyu.more_world_crafting.recipe.FluidConversionRecipe;
import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidConversionCategory
implements IRecipeCategory<FluidConversionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("more_world_crafting", "fluid_conversion");
    public static final RecipeType<FluidConversionRecipe> FLUID_CONVERSION_TYPE = new RecipeType(UID, FluidConversionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final JEIDrawHelper drawHelper;
    private final IMultiIconProvider catalystIconProvider;

    public FluidConversionCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(150, 60);
        this.icon = JEIMultiIconUtils.createLavaIcon(helper);
        this.catalystIconProvider = new MultiIconProvider.Builder(helper).addItemIcon(new ItemStack((ItemLike)Items.f_42448_)).addFluidIcon(new FluidStack((Fluid)Fluids.f_76195_, 1000)).setAlternating(true).setAlternatingInterval(30).build();
        this.drawHelper = new JEIDrawHelper(helper);
    }

    public RecipeType<FluidConversionRecipe> getRecipeType() {
        return FLUID_CONVERSION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.more_world_crafting.fluid_conversion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidConversionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 22).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getIngredient().m_43908_()));
        FluidStack requiredFluidStack = new FluidStack(recipe.getRequiredFluid(), 1000);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 46, 22).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)requiredFluidStack)).setSlotName("required_fluid");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 22).addItemStack(recipe.m_8043_(null));
    }

    public void draw(FluidConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.drawHelper.drawSlot(guiGraphics, 9, 21);
        this.drawHelper.drawSlot(guiGraphics, 45, 21);
        this.drawHelper.drawSlot(guiGraphics, 115, 21);
        this.drawHelper.drawArrow(guiGraphics, 75, 24);
        float chance = recipe.getConversionChance();
        int percentage = Math.round(chance * 100.0f);
        MutableComponent chanceText = Component.m_237110_((String)"jei.more_world_crafting.conversion_chance", (Object[])new Object[]{percentage + "%"});
        int centerX = 36;
        int textX = centerX - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)chanceText) / 2;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)chanceText, textX, 45, 0x555555, false);
    }
}

