/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.jei.category;

import com.xiaoyu.more_world_crafting.compat.jei.api.IMultiIconProvider;
import com.xiaoyu.more_world_crafting.compat.jei.api.JEIDrawHelper;
import com.xiaoyu.more_world_crafting.compat.jei.api.JEIMultiIconUtils;
import com.xiaoyu.more_world_crafting.compat.jei.api.MultiIconProvider;
import com.xiaoyu.more_world_crafting.recipe.FluidFusionRecipe;
import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidFusionCategory
implements IRecipeCategory<FluidFusionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("more_world_crafting", "fluid_fusion");
    public static final RecipeType<FluidFusionRecipe> FLUID_FUSION_TYPE = new RecipeType(UID, FluidFusionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final JEIDrawHelper drawHelper;
    private final IMultiIconProvider catalystIconProvider;

    private int[][] getItemPositions(int count) {
        int baseX = 9;
        int baseY = 11;
        int spacing = 18;
        switch (count) {
            case 1: {
                return new int[][]{{baseX + spacing + spacing / 2, baseY + spacing / 2}};
            }
            case 2: {
                return new int[][]{{baseX + spacing, baseY + spacing / 2}, {baseX + spacing * 2, baseY + spacing / 2}};
            }
            case 3: {
                return new int[][]{{baseX + spacing + spacing / 2, baseY}, {baseX + spacing, baseY + spacing}, {baseX + spacing * 2, baseY + spacing}};
            }
            case 4: {
                return new int[][]{{baseX + spacing, baseY}, {baseX + spacing * 2, baseY}, {baseX + spacing, baseY + spacing}, {baseX + spacing * 2, baseY + spacing}};
            }
            case 5: {
                return new int[][]{{baseX + spacing, baseY}, {baseX + spacing * 2, baseY}, {baseX + spacing + spacing / 2, baseY + spacing / 2}, {baseX + spacing, baseY + spacing}, {baseX + spacing * 2, baseY + spacing}};
            }
            case 6: {
                return new int[][]{{baseX + spacing / 2, baseY}, {baseX + spacing + spacing / 2, baseY}, {baseX + spacing * 2 + spacing / 2, baseY}, {baseX + spacing / 2, baseY + spacing}, {baseX + spacing + spacing / 2, baseY + spacing}, {baseX + spacing * 2 + spacing / 2, baseY + spacing}};
            }
            case 7: {
                return new int[][]{{baseX + spacing / 2, baseY}, {baseX + spacing + spacing / 2, baseY}, {baseX + spacing * 2 + spacing / 2, baseY}, {baseX, baseY + spacing}, {baseX + spacing, baseY + spacing}, {baseX + spacing * 2, baseY + spacing}, {baseX + spacing * 3, baseY + spacing}};
            }
        }
        int[][] positions = new int[Math.min(count, 8)][];
        for (int i = 0; i < Math.min(count, 8); ++i) {
            positions[i] = new int[]{baseX + i % 4 * spacing, baseY + i / 4 * spacing};
        }
        return positions;
    }

    public FluidFusionCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(176, 85);
        this.icon = JEIMultiIconUtils.createWaterIcon(helper);
        this.catalystIconProvider = new MultiIconProvider.Builder(helper).addItemIcon(new ItemStack((ItemLike)Items.f_42447_)).addFluidIcon(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setAlternating(true).setAlternatingInterval(30).build();
        this.drawHelper = new JEIDrawHelper(helper);
    }

    public RecipeType<FluidFusionRecipe> getRecipeType() {
        return FLUID_FUSION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.more_world_crafting.fluid_fusion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidFusionRecipe recipe, IFocusGroup focuses) {
        int ingredientCount = recipe.m_7527_().size();
        int[][] positions = this.getItemPositions(ingredientCount);
        for (int i = 0; i < Math.min(ingredientCount, 8); ++i) {
            int x = positions[i][0];
            int y = positions[i][1];
            Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(ingredient.m_43908_()));
        }
        FluidStack requiredFluidStack = new FluidStack(recipe.getRequiredFluid(), 1000);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 92, 20).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)requiredFluidStack)).setSlotName("required_fluid");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 20).addItemStack(recipe.m_8043_(null));
    }

    public void draw(FluidFusionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int ingredientCount = recipe.m_7527_().size();
        int[][] positions = this.getItemPositions(ingredientCount);
        for (int i = 0; i < Math.min(ingredientCount, 8); ++i) {
            int x = positions[i][0] - 1;
            int y = positions[i][1] - 1;
            this.drawHelper.drawSlot(guiGraphics, x, y);
        }
        this.drawHelper.drawSlot(guiGraphics, 91, 19);
        this.drawHelper.drawArrow(guiGraphics, 115, 19);
        this.drawHelper.drawSlot(guiGraphics, 141, 19);
        double fusionTimeInSeconds = (double)recipe.getFusionTime() / 20.0;
        String timeFormat = fusionTimeInSeconds == Math.floor(fusionTimeInSeconds) ? "%.0f" : "%.1f";
        MutableComponent timeText = Component.m_237110_((String)"jei.more_world_crafting.fusion_time", (Object[])new Object[]{String.format(timeFormat, fusionTimeInSeconds)});
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)timeText, 8, 61, 0x404040, false);
        MutableComponent infoText = Component.m_237115_((String)"jei.more_world_crafting.fluid_fusion_info");
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)infoText, 8, 71, 0x606060, false);
    }
}

