/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.xiaoyu.more_world_crafting.compat.jei.api.JEIDrawHelper;
import com.xiaoyu.more_world_crafting.recipe.LightningConversionRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LightningConversionCategory
implements IRecipeCategory<LightningConversionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("more_world_crafting", "lightning_conversion");
    public static final RecipeType<LightningConversionRecipe> LIGHTNING_CONVERSION_TYPE = new RecipeType(UID, LightningConversionRecipe.class);
    private static final int WEATHER_X = 133;
    private static final int WEATHER_Y = 1;
    private final IDrawable background;
    private final IDrawable icon;
    private final JEIDrawHelper drawHelper;
    private final IGuiHelper guiHelper;

    public LightningConversionCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(150, 70);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_151041_));
        this.drawHelper = new JEIDrawHelper(helper);
        this.guiHelper = helper;
    }

    public RecipeType<LightningConversionRecipe> getRecipeType() {
        return LIGHTNING_CONVERSION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.more_world_crafting.lightning_conversion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LightningConversionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 22).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getIngredient().m_43908_()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 46, 22).setSlotName("lightning");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 22).addItemStack(recipe.m_8043_(null));
    }

    public void draw(LightningConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.drawHelper.drawSlot(guiGraphics, 9, 21);
        this.drawHelper.drawSlot(guiGraphics, 115, 21);
        guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_151041_), 46, 22);
        this.drawHelper.drawArrow(guiGraphics, 75, 24);
        float lightningChance = recipe.getLightningChance();
        int lightningPercentage = Math.round(lightningChance * 100.0f);
        MutableComponent attractText = Component.m_237110_((String)"jei.more_world_crafting.lightning_absorption_chance", (Object[])new Object[]{lightningPercentage + "%"});
        int centerX = 37;
        int attractTextX = centerX - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)attractText) / 2;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)attractText, attractTextX, 45, 0x555555, false);
        float conversionChance = recipe.getConversionChance();
        int conversionPercentage = Math.round(conversionChance * 100.0f);
        MutableComponent conversionText = Component.m_237110_((String)"jei.more_world_crafting.lightning_conversion_chance", (Object[])new Object[]{conversionPercentage + "%"});
        int conversionTextX = attractTextX;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)conversionText, conversionTextX, 55, 0x555555, false);
        this.drawWeatherSlotAndIcon(guiGraphics, recipe.getWeatherId());
    }

    private void drawWeatherSlotAndIcon(GuiGraphics guiGraphics, String weatherId) {
        if (weatherId == null || weatherId.isEmpty()) {
            return;
        }
        int slotX = 132;
        int slotY = 0;
        this.drawHelper.drawSlot(guiGraphics, slotX, slotY);
        String iconName = this.getWeatherIconName(weatherId);
        if (iconName != null) {
            ResourceLocation weatherIconLocation = new ResourceLocation("more_world_crafting", "textures/icon/weather/" + iconName + ".png");
            int iconSize = 16;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)weatherIconLocation);
            guiGraphics.m_280163_(weatherIconLocation, 133, 1, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
    }

    private String getWeatherIconName(String weatherId) {
        switch (weatherId) {
            case "minecraft:clear": {
                return "clear";
            }
            case "minecraft:rain": {
                return "rain";
            }
            case "minecraft:thunder": {
                return "thunder";
            }
        }
        return null;
    }

    private Component getWeatherName(String weatherId) {
        switch (weatherId) {
            case "minecraft:clear": {
                return Component.m_237115_((String)"jei.more_world_crafting.weather.clear");
            }
            case "minecraft:rain": {
                return Component.m_237115_((String)"jei.more_world_crafting.weather.rain");
            }
            case "minecraft:thunder": {
                return Component.m_237115_((String)"jei.more_world_crafting.weather.thunder");
            }
        }
        return null;
    }

    public List<Component> getTooltipStrings(LightningConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (recipe.getWeatherId() != null && !recipe.getWeatherId().isEmpty()) {
            Component weatherName;
            int iconSize = 16;
            if (mouseX >= 133.0 && mouseX < (double)(133 + iconSize) && mouseY >= 1.0 && mouseY < (double)(1 + iconSize) && (weatherName = this.getWeatherName(recipe.getWeatherId())) != null) {
                tooltips.add(weatherName);
            }
        }
        return tooltips;
    }
}

