/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.compat.jei.category;

import com.xiaoyu.more_world_crafting.compat.jei.api.JEIDrawHelper;
import com.xiaoyu.more_world_crafting.compat.jei.api.JEIMultiIconUtils;
import com.xiaoyu.more_world_crafting.recipe.VoidConversionRecipe;
import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoidConversionCategory
implements IRecipeCategory<VoidConversionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("more_world_crafting", "void_conversion");
    public static final RecipeType<VoidConversionRecipe> VOID_CONVERSION_TYPE = new RecipeType(UID, VoidConversionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final JEIDrawHelper drawHelper;

    public VoidConversionCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(150, 60);
        this.icon = JEIMultiIconUtils.createVoidIcon(helper);
        this.drawHelper = new JEIDrawHelper(helper);
    }

    public RecipeType<VoidConversionRecipe> getRecipeType() {
        return VOID_CONVERSION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.more_world_crafting.void_conversion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VoidConversionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 22).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getIngredient().m_43908_()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 46, 22).setSlotName("void");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 22).addItemStack(recipe.m_8043_(null));
    }

    public void draw(VoidConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.drawHelper.drawSlot(guiGraphics, 9, 21);
        this.drawHelper.drawSlot(guiGraphics, 115, 21);
        ResourceLocation voidTexture = new ResourceLocation("minecraft", "textures/entity/end_portal.png");
        guiGraphics.m_280163_(voidTexture, 46, 22, 0.0f, 0.0f, 16, 16, 16, 16);
        this.drawHelper.drawArrow(guiGraphics, 75, 24);
        float chance = recipe.getConversionChance();
        int percentage = Math.round(chance * 100.0f);
        MutableComponent chanceText = Component.m_237110_((String)"jei.more_world_crafting.conversion_chance", (Object[])new Object[]{percentage + "%"});
        int centerX = 35;
        int textX = centerX - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)chanceText) / 2;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)chanceText, textX, 45, 0x555555, false);
    }
}

