/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.CrushingConversionRecipe;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CrushingConversionManager {
    private static final Map<UUID, FallingBlockData> TRACKED_FALLING_BLOCKS = new HashMap<UUID, FallingBlockData>();
    private static final Map<ResourceLocation, CrushingConversionRecipe> customRecipes = new HashMap<ResourceLocation, CrushingConversionRecipe>();
    private static final double COLLISION_HORIZONTAL_RADIUS = 0.8;
    private static final double COLLISION_VERTICAL_RADIUS = 1.5;
    private static final double MIN_FALL_VELOCITY = 0.1;
    private static final int TICK_INTERVAL = 2;

    public static void tick(Level level) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (level.m_46467_() % 2L != 0L) {
            return;
        }
        CrushingConversionManager.trackNewFallingBlocks(serverLevel);
        CrushingConversionManager.processTrackedBlocks(serverLevel);
    }

    private static void trackNewFallingBlocks(ServerLevel level) {
        for (Entity entity : level.m_8583_()) {
            FallingBlockEntity fallingBlock;
            UUID blockId;
            if (!(entity instanceof FallingBlockEntity) || TRACKED_FALLING_BLOCKS.containsKey(blockId = (fallingBlock = (FallingBlockEntity)entity).m_20148_()) || !CrushingConversionManager.isValidCrushingBlock(fallingBlock)) continue;
            TRACKED_FALLING_BLOCKS.put(blockId, new FallingBlockData(level.m_46472_().m_135782_().toString(), fallingBlock.m_20186_(), fallingBlock.m_20185_(), fallingBlock.m_20189_()));
        }
    }

    private static boolean isValidCrushingBlock(FallingBlockEntity fallingBlock) {
        return !fallingBlock.m_213877_() && fallingBlock.m_6084_();
    }

    private static void processTrackedBlocks(ServerLevel level) {
        Iterator<Map.Entry<UUID, FallingBlockData>> iterator = TRACKED_FALLING_BLOCKS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, FallingBlockData> entry = iterator.next();
            UUID blockId = entry.getKey();
            FallingBlockData fallData = entry.getValue();
            if (!CrushingConversionManager.isDimensionMatch(fallData, level)) continue;
            FallingBlockEntity fallingBlock = CrushingConversionManager.findFallingBlock(level, blockId);
            if (fallingBlock == null) {
                iterator.remove();
                continue;
            }
            boolean shouldRemove = CrushingConversionManager.processBlockConversion(level, fallingBlock, fallData);
            if (!shouldRemove) continue;
            iterator.remove();
        }
    }

    private static boolean isDimensionMatch(FallingBlockData fallData, ServerLevel level) {
        return fallData.dimension.equals(level.m_46472_().m_135782_().toString());
    }

    private static FallingBlockEntity findFallingBlock(ServerLevel level, UUID blockId) {
        for (Entity entity : level.m_8583_()) {
            FallingBlockEntity fallingBlock;
            if (!(entity instanceof FallingBlockEntity) || !(fallingBlock = (FallingBlockEntity)entity).m_20148_().equals(blockId) || fallingBlock.m_213877_()) continue;
            return fallingBlock;
        }
        return null;
    }

    private static boolean processBlockConversion(ServerLevel level, FallingBlockEntity fallingBlock, FallingBlockData fallData) {
        boolean hasMinimumVelocity;
        if (fallData.processed) {
            return true;
        }
        double velocity = Math.abs(fallingBlock.m_20184_().f_82480_);
        boolean isOnGround = fallingBlock.m_20096_();
        boolean bl = hasMinimumVelocity = velocity >= 0.1;
        if (!isOnGround && !hasMinimumVelocity) {
            return false;
        }
        List<ItemEntity> nearbyItems = CrushingConversionManager.findNearbyItems(level, fallingBlock);
        for (ItemEntity item : nearbyItems) {
            CrushingConversionRecipe recipe = CrushingConversionManager.findMatchingRecipe(level, item, fallingBlock);
            if (recipe == null) continue;
            double itemY = item.m_20186_();
            double totalHeight = Math.ceil(fallData.startY) - Math.floor(itemY) + 1.0;
            if (!(totalHeight >= (double)recipe.getMinHeight())) continue;
            CrushingConversionManager.executeConversion(level, item, recipe);
            fallData.processed = true;
            return true;
        }
        return isOnGround;
    }

    private static List<ItemEntity> findNearbyItems(ServerLevel level, FallingBlockEntity fallingBlock) {
        ArrayList<ItemEntity> nearbyItems = new ArrayList<ItemEntity>();
        Vec3 blockPos = fallingBlock.m_20182_();
        for (Entity entity : level.m_8583_()) {
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_213877_() || item.m_32055_().m_41619_()) continue;
            Vec3 itemPos = item.m_20182_();
            double horizontalDistance = Math.sqrt(Math.pow(blockPos.f_82479_ - itemPos.f_82479_, 2.0) + Math.pow(blockPos.f_82481_ - itemPos.f_82481_, 2.0));
            double verticalDistance = Math.abs(blockPos.f_82480_ - itemPos.f_82480_);
            if (!(horizontalDistance <= 0.8) || !(verticalDistance <= 1.5)) continue;
            nearbyItems.add(item);
        }
        return nearbyItems;
    }

    private static CrushingConversionRecipe findMatchingRecipe(ServerLevel level, ItemEntity item, FallingBlockEntity fallingBlock) {
        ItemStack itemStack = item.m_32055_();
        BlockState blockState = fallingBlock.m_31980_();
        Item blockItem = blockState.m_60734_().m_5456_();
        ResourceLocation blockItemId = BuiltInRegistries.f_257033_.m_7981_((Object)blockItem);
        List<CrushingConversionRecipe> allRecipes = CrushingConversionManager.getAllRecipes(level);
        for (CrushingConversionRecipe recipe : allRecipes) {
            String recipeGravityType;
            if (!recipe.getIngredient().test(itemStack) || !(recipeGravityType = recipe.getGravityType()).equals(blockItemId.toString())) continue;
            return recipe;
        }
        return null;
    }

    private static List<CrushingConversionRecipe> getAllRecipes(ServerLevel level) {
        ArrayList<CrushingConversionRecipe> allRecipes = new ArrayList<CrushingConversionRecipe>();
        List registeredRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.CRUSHING_CONVERSION.get());
        allRecipes.addAll(registeredRecipes);
        allRecipes.addAll(customRecipes.values());
        return allRecipes;
    }

    private static void executeConversion(ServerLevel level, ItemEntity originalItem, CrushingConversionRecipe recipe) {
        ItemStack inputStack = originalItem.m_32055_();
        int inputCount = inputStack.m_41613_();
        int successfulConversions = CraftingAPI.calculateSuccessfulConversions(inputCount, recipe.getConversionChance(), level);
        if (successfulConversions <= 0) {
            return;
        }
        ItemStack outputStack = recipe.m_8043_(level.m_9598_()).m_41777_();
        int outputCount = outputStack.m_41613_();
        outputStack.m_41764_(outputCount * successfulConversions);
        Vec3 position = originalItem.m_20182_();
        originalItem.m_146870_();
        ItemEntity resultItem = CraftingAPI.createOutputItemWithJump(level, position, outputStack, originalItem, 0.3);
        level.m_7967_((Entity)resultItem);
    }

    public static void addCustomRecipe(CrushingConversionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<CrushingConversionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }

    private static class FallingBlockData {
        public final String dimension;
        public final double startY;
        public final double startX;
        public final double startZ;
        public boolean processed;

        public FallingBlockData(String dimension, double startY, double startX, double startZ) {
            this.dimension = dimension;
            this.startY = startY;
            this.startX = startX;
            this.startZ = startZ;
            this.processed = false;
        }
    }
}

