/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.ExplosionConversionRecipe;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="more_world_crafting")
public class ExplosionConversionManager {
    private static final Map<UUID, ConversionData> pendingConversions = new HashMap<UUID, ConversionData>();
    private static final Map<ResourceLocation, ExplosionConversionRecipe> customRecipes = new HashMap<ResourceLocation, ExplosionConversionRecipe>();
    private static final double EXPLOSION_JUMP_HEIGHT = 0.6;
    private static final int CONVERSION_DELAY = 10;
    private static final double EXPLOSION_RADIUS = 8.0;

    public static void tick(Level level) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExplosionConversionManager.processConversions(serverLevel);
    }

    private static void processConversions(ServerLevel level) {
        Iterator<Map.Entry<UUID, ConversionData>> iterator = pendingConversions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ConversionData> entry = iterator.next();
            ConversionData data = entry.getValue();
            ++data.tickCount;
            if (data.tickCount < 10) continue;
            ItemEntity targetItem = null;
            for (Entity entity : level.m_8583_()) {
                ItemEntity item;
                if (!(entity instanceof ItemEntity) || !(item = (ItemEntity)entity).m_20148_().equals(data.itemId) || item.m_213877_()) continue;
                targetItem = item;
                break;
            }
            if (targetItem != null) {
                boolean conversionSuccess = ExplosionConversionManager.performConversion(level, data.originalItemStack, data.recipe, data.targetPlayer, data.position);
                if (conversionSuccess) {
                    targetItem.m_146870_();
                } else {
                    targetItem.m_20331_(false);
                }
            } else {
                ExplosionConversionManager.performConversion(level, data.originalItemStack, data.recipe, data.targetPlayer, data.position);
            }
            iterator.remove();
        }
    }

    public static void preHandleExplosion(ServerLevel level, Explosion explosion) {
        if (level.m_5776_()) {
            return;
        }
        Vec3 explosionPos = explosion.getPosition();
        AABB searchArea = new AABB(explosionPos.f_82479_ - 8.0, explosionPos.f_82480_ - 8.0, explosionPos.f_82481_ - 8.0, explosionPos.f_82479_ + 8.0, explosionPos.f_82480_ + 8.0, explosionPos.f_82481_ + 8.0);
        List itemsInArea = level.m_45976_(ItemEntity.class, searchArea);
        for (ItemEntity itemEntity : itemsInArea) {
            UUID itemId;
            ExplosionConversionRecipe recipe;
            if (itemEntity.m_213877_() || itemEntity.m_32055_().m_41619_() || (recipe = ExplosionConversionManager.findMatchingRecipe(level, itemEntity.m_32055_())) == null || pendingConversions.containsKey(itemId = itemEntity.m_20148_())) continue;
            Player targetPlayer = ExplosionConversionManager.getItemThrower(itemEntity);
            pendingConversions.put(itemId, new ConversionData(itemId, targetPlayer, recipe, itemEntity.m_32055_().m_41777_(), itemEntity.m_20182_()));
            itemEntity.m_20331_(true);
        }
    }

    private static boolean performConversion(ServerLevel level, ItemStack originalStack, ExplosionConversionRecipe recipe, Player targetPlayer, Vec3 position) {
        int inputCount = originalStack.m_41613_();
        if (inputCount <= 0) {
            return false;
        }
        int successfulConversions = CraftingAPI.calculateSuccessfulConversions(inputCount, recipe.getConversionChance(), level);
        if (successfulConversions <= 0) {
            return false;
        }
        ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
        if (result.m_41619_()) {
            return false;
        }
        int resultPerInput = result.m_41613_();
        int totalResultCount = Math.max(1, successfulConversions * resultPerInput);
        result.m_41764_(totalResultCount);
        ItemEntity resultEntity = CraftingAPI.createOutputItemWithJump(level, position, result, null, 0.6);
        return level.m_7967_((Entity)resultEntity);
    }

    private static ExplosionConversionRecipe findMatchingRecipe(ServerLevel level, ItemStack itemStack) {
        List recipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.EXPLOSION_CONVERSION.get());
        ArrayList<ExplosionConversionRecipe> allRecipes = new ArrayList<ExplosionConversionRecipe>(recipes);
        allRecipes.addAll(customRecipes.values());
        for (ExplosionConversionRecipe recipe : allRecipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            return recipe;
        }
        return null;
    }

    private static Player getItemThrower(ItemEntity item) {
        Entity entity = item.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ExplosionConversionManager.preHandleExplosion(serverLevel, event.getExplosion());
        }
    }

    public static void addCustomRecipe(ExplosionConversionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<ExplosionConversionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }

    private static class ConversionData {
        UUID itemId;
        Player targetPlayer;
        ExplosionConversionRecipe recipe;
        ItemStack originalItemStack;
        Vec3 position;
        int tickCount;

        ConversionData(UUID itemId, Player targetPlayer, ExplosionConversionRecipe recipe, ItemStack originalItemStack, Vec3 position) {
            this.itemId = itemId;
            this.targetPlayer = targetPlayer;
            this.recipe = recipe;
            this.originalItemStack = originalItemStack;
            this.position = position;
            this.tickCount = 0;
        }
    }
}

