/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.FireConversionRecipe;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class FireConversionManager {
    private static final Map<UUID, ConversionData> pendingConversions = new HashMap<UUID, ConversionData>();
    private static final Map<ResourceLocation, FireConversionRecipe> customRecipes = new HashMap<ResourceLocation, FireConversionRecipe>();
    private static final double FIRE_JUMP_HEIGHT = 0.8;
    private static final int CONVERSION_DELAY = 10;

    public static void tick(Level level) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (Entity entity : serverLevel.m_8583_()) {
            UUID itemId;
            FireConversionRecipe recipe;
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_213877_() || item.m_32055_().m_41619_() || (recipe = FireConversionManager.findMatchingRecipe(serverLevel, item.m_32055_())) == null || !FireConversionManager.isCorrectFireType(serverLevel, item.m_20182_(), recipe.getFireType()) || pendingConversions.containsKey(itemId = item.m_20148_())) continue;
            Player targetPlayer = FireConversionManager.getItemThrower(item);
            pendingConversions.put(itemId, new ConversionData(itemId, targetPlayer, recipe, item.m_32055_().m_41777_(), item.m_20182_()));
        }
        FireConversionManager.processConversions(serverLevel);
        FireConversionManager.processJumpingOutputItems(serverLevel);
    }

    private static void processConversions(ServerLevel level) {
        Iterator<Map.Entry<UUID, ConversionData>> iterator = pendingConversions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ConversionData> entry = iterator.next();
            ConversionData data = entry.getValue();
            ++data.tickCount;
            if (data.tickCount < 10) continue;
            ItemEntity targetItem = null;
            for (Entity entity : level.m_8583_()) {
                ItemEntity item;
                if (!(entity instanceof ItemEntity) || !(item = (ItemEntity)entity).m_20148_().equals(data.itemId) || item.m_213877_()) continue;
                targetItem = item;
                break;
            }
            if (targetItem != null) {
                boolean conversionSuccess;
                if (FireConversionManager.isCorrectFireType(level, targetItem.m_20182_(), data.recipe.getFireType()) && (conversionSuccess = FireConversionManager.performConversion(level, data.originalItemStack, data.recipe, data.targetPlayer, data.position))) {
                    targetItem.m_146870_();
                }
            } else {
                FireConversionManager.performConversion(level, data.originalItemStack, data.recipe, data.targetPlayer, data.position);
            }
            iterator.remove();
        }
    }

    private static Player getItemThrower(ItemEntity item) {
        Entity entity = item.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    private static FireConversionRecipe findMatchingRecipe(ServerLevel level, ItemStack itemStack) {
        ArrayList<FireConversionRecipe> allRecipes = new ArrayList<FireConversionRecipe>();
        List datapackRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.FIRE_CONVERSION.get());
        allRecipes.addAll(datapackRecipes);
        allRecipes.addAll(customRecipes.values());
        for (FireConversionRecipe recipe : allRecipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean performConversion(ServerLevel level, ItemStack originalStack, FireConversionRecipe recipe, Player targetPlayer, Vec3 position) {
        int inputCount = originalStack.m_41613_();
        if (inputCount <= 0) {
            return false;
        }
        int successfulConversions = CraftingAPI.calculateSuccessfulConversions(inputCount, recipe.getConversionChance(), level);
        if (successfulConversions <= 0) {
            return false;
        }
        ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
        if (result.m_41619_()) {
            return false;
        }
        int resultPerInput = result.m_41613_();
        int totalResultCount = Math.max(1, successfulConversions * resultPerInput);
        result.m_41764_(totalResultCount);
        ItemEntity resultEntity = CraftingAPI.createOutputItemWithJump(level, position, result, null, 0.8);
        return level.m_7967_((Entity)resultEntity);
    }

    private static boolean isCorrectFireType(ServerLevel level, Vec3 position, FireConversionRecipe.FireType fireType) {
        BlockPos pos = BlockPos.m_274446_((Position)position);
        BlockPos posBelow = pos.m_7495_();
        switch (fireType) {
            case NORMAL_FIRE: {
                return level.m_8055_(pos).m_60713_(Blocks.f_50083_) || level.m_8055_(posBelow).m_60713_(Blocks.f_50083_);
            }
            case SOUL_FIRE: {
                return level.m_8055_(pos).m_60713_(Blocks.f_50084_) || level.m_8055_(posBelow).m_60713_(Blocks.f_50084_);
            }
            case CAMPFIRE: {
                return level.m_8055_(pos).m_60713_(Blocks.f_50683_) || level.m_8055_(posBelow).m_60713_(Blocks.f_50683_);
            }
            case SOUL_CAMPFIRE: {
                return level.m_8055_(pos).m_60713_(Blocks.f_50684_) || level.m_8055_(posBelow).m_60713_(Blocks.f_50684_);
            }
        }
        return false;
    }

    private static void performFireJump(ItemEntity itemEntity) {
        Vec3 velocity = itemEntity.m_20184_();
        Vec3 jumpVelocity = new Vec3(velocity.f_82479_, 0.8, velocity.f_82481_);
        itemEntity.m_20256_(jumpVelocity);
        itemEntity.f_19812_ = true;
    }

    private static void processJumpingOutputItems(ServerLevel level) {
        for (Entity entity : level.m_8583_()) {
            BlockPos pos;
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_213877_() || !item.m_20147_() || !FireConversionManager.isInFireEnvironment(level, pos = item.m_20183_())) continue;
            FireConversionManager.performFireJump(item);
        }
    }

    private static boolean isInFireEnvironment(ServerLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(Blocks.f_50083_) || level.m_8055_(pos).m_60713_(Blocks.f_50084_) || level.m_8055_(pos).m_60713_(Blocks.f_50683_) || level.m_8055_(pos).m_60713_(Blocks.f_50684_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50083_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50084_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50683_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50684_);
    }

    public static void addCustomRecipe(FireConversionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<FireConversionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }

    private static class ConversionData {
        UUID itemId;
        Player targetPlayer;
        FireConversionRecipe recipe;
        ItemStack originalItemStack;
        Vec3 position;
        int tickCount;

        ConversionData(UUID itemId, Player targetPlayer, FireConversionRecipe recipe, ItemStack originalItemStack, Vec3 position) {
            this.itemId = itemId;
            this.targetPlayer = targetPlayer;
            this.recipe = recipe;
            this.originalItemStack = originalItemStack;
            this.position = position;
            this.tickCount = 0;
        }
    }
}

