/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.FluidConversionRecipe;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class FluidConversionManager {
    private static final Map<UUID, ConversionData> pendingConversions = new HashMap<UUID, ConversionData>();
    private static final Map<ResourceLocation, FluidConversionRecipe> customRecipes = new HashMap<ResourceLocation, FluidConversionRecipe>();
    private static final double LAVA_JUMP_HEIGHT = 0.8;
    private static final int CONVERSION_DELAY = 20;

    public static void tick(Level level) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (Entity entity : serverLevel.m_8583_()) {
            UUID itemId;
            FluidConversionRecipe recipe;
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_213877_() || item.m_32055_().m_41619_() || (recipe = FluidConversionManager.findMatchingRecipe(serverLevel, item.m_32055_())) == null || !FluidConversionManager.isInCorrectFluid(serverLevel, item.m_20182_(), recipe) || pendingConversions.containsKey(itemId = item.m_20148_())) continue;
            Player targetPlayer = FluidConversionManager.getItemThrower(item);
            pendingConversions.put(itemId, new ConversionData(itemId, targetPlayer, recipe, item.m_32055_().m_41777_(), item.m_20182_()));
        }
        FluidConversionManager.processConversions(serverLevel);
        FluidConversionManager.processJumpingOutputItems(serverLevel);
    }

    private static void processConversions(ServerLevel level) {
        Iterator<Map.Entry<UUID, ConversionData>> iterator = pendingConversions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ConversionData> entry = iterator.next();
            ConversionData data = entry.getValue();
            ++data.tickCount;
            if (data.tickCount < 20) continue;
            boolean itemFound = false;
            for (Entity entity : level.m_8583_()) {
                ItemEntity item;
                if (!(entity instanceof ItemEntity) || !(item = (ItemEntity)entity).m_20148_().equals(data.itemId) || item.m_213877_()) continue;
                item.m_146870_();
                itemFound = true;
                break;
            }
            if (itemFound) {
                FluidConversionManager.performConversion(level, data.originalItemStack, data.recipe, data.targetPlayer, data.position);
            }
            iterator.remove();
        }
    }

    private static Player getItemThrower(ItemEntity item) {
        Entity entity = item.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    private static FluidConversionRecipe findMatchingRecipe(ServerLevel level, ItemStack itemStack) {
        ArrayList<FluidConversionRecipe> allRecipes = new ArrayList<FluidConversionRecipe>();
        List datapackRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.FLUID_CONVERSION.get());
        allRecipes.addAll(datapackRecipes);
        allRecipes.addAll(customRecipes.values());
        for (FluidConversionRecipe recipe : allRecipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean performConversion(ServerLevel level, ItemStack originalStack, FluidConversionRecipe recipe, Player targetPlayer, Vec3 position) {
        int inputCount = originalStack.m_41613_();
        if (inputCount <= 0) {
            return false;
        }
        int successfulConversions = CraftingAPI.calculateSuccessfulConversions(inputCount, recipe.getConversionChance(), level);
        if (successfulConversions <= 0) {
            return false;
        }
        ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
        if (result.m_41619_()) {
            return false;
        }
        int resultPerInput = result.m_41613_();
        int totalResultCount = Math.max(1, successfulConversions * resultPerInput);
        result.m_41764_(totalResultCount);
        ItemEntity resultEntity = CraftingAPI.createOutputItemWithJump(level, position, result, null, 0.8);
        return level.m_7967_((Entity)resultEntity);
    }

    private static boolean isInCorrectFluid(ServerLevel level, Vec3 position, FluidConversionRecipe recipe) {
        BlockPos pos = BlockPos.m_274446_((Position)position);
        BlockPos posBelow = pos.m_7495_();
        return level.m_6425_(pos).m_192917_(recipe.getRequiredFluid()) || level.m_6425_(posBelow).m_192917_(recipe.getRequiredFluid());
    }

    private static void performLavaJump(ItemEntity itemEntity) {
        Vec3 velocity = itemEntity.m_20184_();
        Vec3 jumpVelocity = new Vec3(velocity.f_82479_, 0.8, velocity.f_82481_);
        itemEntity.m_20256_(jumpVelocity);
        itemEntity.f_19812_ = true;
    }

    private static void processJumpingOutputItems(ServerLevel level) {
        for (Entity entity : level.m_8583_()) {
            BlockPos pos;
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_213877_() || !item.m_20147_() || !level.m_6425_(pos = item.m_20183_()).m_192917_((Fluid)Fluids.f_76195_) && !level.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76195_)) continue;
            FluidConversionManager.performLavaJump(item);
        }
    }

    public static void addCustomRecipe(FluidConversionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<FluidConversionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }

    private static class ConversionData {
        UUID itemId;
        Player targetPlayer;
        FluidConversionRecipe recipe;
        ItemStack originalItemStack;
        Vec3 position;
        int tickCount;

        ConversionData(UUID itemId, Player targetPlayer, FluidConversionRecipe recipe, ItemStack originalItemStack, Vec3 position) {
            this.itemId = itemId;
            this.targetPlayer = targetPlayer;
            this.recipe = recipe;
            this.originalItemStack = originalItemStack;
            this.position = position;
            this.tickCount = 0;
        }
    }
}

