/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.FluidFusionRecipe;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FluidFusionManager {
    private static final Map<String, Integer> activeFusions = new HashMap<String, Integer>();
    private static final Map<ResourceLocation, FluidFusionRecipe> customRecipes = new HashMap<ResourceLocation, FluidFusionRecipe>();
    private static final double SEARCH_RADIUS = 3.0;

    public static void tick(Level level) {
        if (level.m_5776_()) {
            return;
        }
        List<ItemEntity> fluidItems = FluidFusionManager.getFluidItems(level);
        Map<String, List<ItemEntity>> itemGroups = FluidFusionManager.groupItemsByRegion(fluidItems);
        for (Map.Entry<String, List<ItemEntity>> entry2 : itemGroups.entrySet()) {
            String regionKey = entry2.getKey();
            List<ItemEntity> items = entry2.getValue();
            if (items.size() < 2) continue;
            FluidFusionRecipe recipe = FluidFusionManager.findMatchingRecipe(level, items);
            if (recipe != null) {
                List<ItemEntity> fusionInputs = FluidFusionManager.findItemsForRecipe(items, recipe.m_7527_());
                for (ItemEntity inputItem : fusionInputs) {
                    CraftingAPI.protectFluidFusionInput(inputItem);
                }
                Integer tickTime = activeFusions.get(regionKey);
                if (tickTime == null) {
                    tickTime = 0;
                }
                Integer n = tickTime;
                tickTime = tickTime + 1;
                activeFusions.put(regionKey, tickTime);
                if (tickTime < recipe.getFusionTime() || !FluidFusionManager.performFusion(level, items, recipe)) continue;
                activeFusions.remove(regionKey);
                continue;
            }
            activeFusions.remove(regionKey);
        }
        activeFusions.entrySet().removeIf(entry -> {
            Integer tickTime = (Integer)entry.getValue();
            return tickTime > 1200;
        });
    }

    private static List<ItemEntity> getFluidItems(Level level) {
        AABB searchBox = new AABB(-100.0, -64.0, -100.0, 100.0, 320.0, 100.0);
        return level.m_6443_(ItemEntity.class, searchBox, entity -> {
            if (entity.m_32055_().m_41619_() || entity.m_32059_() < 10) {
                return false;
            }
            BlockPos pos = entity.m_20183_();
            return !level.m_6425_(pos).m_76178_();
        });
    }

    private static Map<String, List<ItemEntity>> groupItemsByRegion(List<ItemEntity> items) {
        HashMap<String, List<ItemEntity>> groups = new HashMap<String, List<ItemEntity>>();
        for (ItemEntity item : items) {
            int regionX = (int)Math.floor(item.m_20185_() / 3.0);
            int regionY = (int)Math.floor(item.m_20186_() / 3.0);
            int regionZ = (int)Math.floor(item.m_20189_() / 3.0);
            String regionKey = regionX + "," + regionY + "," + regionZ;
            groups.computeIfAbsent(regionKey, k -> new ArrayList()).add(item);
        }
        return groups;
    }

    private static FluidFusionRecipe findMatchingRecipe(Level level, List<ItemEntity> items) {
        ArrayList<FluidFusionRecipe> allRecipes = new ArrayList<FluidFusionRecipe>();
        List datapackRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.FLUID_FUSION.get());
        allRecipes.addAll(datapackRecipes);
        allRecipes.addAll(customRecipes.values());
        for (FluidFusionRecipe recipe : allRecipes) {
            if (!FluidFusionManager.canMakeRecipe(items, recipe.m_7527_()) || !FluidFusionManager.isInCorrectFluid(level, items, recipe)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean isInCorrectFluid(Level level, List<ItemEntity> items, FluidFusionRecipe recipe) {
        for (ItemEntity item : items) {
            BlockPos pos = item.m_20183_();
            if (level.m_6425_(pos).m_192917_(recipe.getRequiredFluid())) continue;
            return false;
        }
        return true;
    }

    private static int getRequiredCount(Ingredient ingredient, ItemStack stack) {
        ItemStack[] possibleItems = ingredient.m_43908_();
        if (possibleItems.length > 0) {
            for (ItemStack possibleItem : possibleItems) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)possibleItem)) continue;
                return Math.max(1, possibleItem.m_41613_());
            }
        }
        return 1;
    }

    private static boolean canMakeRecipe(List<ItemEntity> items, List<Ingredient> ingredients) {
        ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
        for (ItemEntity item : items) {
            availableStacks.add(item.m_32055_().m_41777_());
        }
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            for (int i = 0; i < availableStacks.size(); ++i) {
                ItemStack stack = (ItemStack)availableStacks.get(i);
                if (stack.m_41619_() || !ingredient.test(stack)) continue;
                int requiredCount = FluidFusionManager.getRequiredCount(ingredient, stack);
                if (stack.m_41613_() < requiredCount) continue;
                stack.m_41774_(requiredCount);
                if (stack.m_41619_()) {
                    availableStacks.remove(i);
                }
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean performFusion(Level level, List<ItemEntity> items, FluidFusionRecipe recipe) {
        List<ItemEntity> itemsToConsume = FluidFusionManager.findItemsForRecipe(items, recipe.m_7527_());
        if (itemsToConsume.size() != recipe.m_7527_().size()) {
            return false;
        }
        double centerX = 0.0;
        double centerY = 0.0;
        double centerZ = 0.0;
        for (ItemEntity item : itemsToConsume) {
            centerX += item.m_20185_();
            centerY += item.m_20186_();
            centerZ += item.m_20189_();
        }
        centerX /= (double)itemsToConsume.size();
        centerY /= (double)itemsToConsume.size();
        centerZ /= (double)itemsToConsume.size();
        for (int i = 0; i < itemsToConsume.size(); ++i) {
            ItemEntity item;
            item = itemsToConsume.get(i);
            Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
            int requiredCount = FluidFusionManager.getRequiredCount(ingredient, item.m_32055_());
            ItemStack stack = item.m_32055_();
            stack.m_41774_(requiredCount);
            if (stack.m_41619_()) {
                item.m_146870_();
                continue;
            }
            item.m_32045_(stack);
        }
        ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
        ItemEntity resultEntity = CraftingAPI.createOutputItem((ServerLevel)level, new Vec3(centerX, centerY + 0.5, centerZ), result, null);
        level.m_7967_((Entity)resultEntity);
        return true;
    }

    private static List<ItemEntity> findItemsForRecipe(List<ItemEntity> items, List<Ingredient> ingredients) {
        ArrayList<ItemEntity> result = new ArrayList<ItemEntity>();
        ArrayList<ItemEntity> availableItems = new ArrayList<ItemEntity>(items);
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            for (int i = 0; i < availableItems.size(); ++i) {
                ItemEntity item = (ItemEntity)availableItems.get(i);
                if (item == null || item.m_32055_().m_41619_() || !ingredient.test(item.m_32055_())) continue;
                int requiredCount = FluidFusionManager.getRequiredCount(ingredient, item.m_32055_());
                if (item.m_32055_().m_41613_() < requiredCount) continue;
                result.add(item);
                availableItems.set(i, null);
                found = true;
                break;
            }
            if (found) continue;
            return new ArrayList<ItemEntity>();
        }
        return result;
    }

    public static void addCustomRecipe(FluidFusionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<FluidFusionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }
}

