/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.config.ModConfig;
import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.LightningConversionRecipe;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LightningConversionManager {
    private static final Map<ResourceLocation, LightningConversionRecipe> customRecipes = new HashMap<ResourceLocation, LightningConversionRecipe>();
    private static final int CHECK_INTERVAL = 20;

    public static void tick(Level level) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (level.m_46467_() % 20L != 0L) {
            return;
        }
        if (!((Boolean)ModConfig.LIGHTNING_CONVERSION_ATTRACTS_LIGHTNING.get()).booleanValue()) {
            return;
        }
        for (Entity entity : serverLevel.m_8583_()) {
            boolean shouldCreateLightning;
            LightningConversionRecipe recipe;
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_32055_().m_41619_() || (recipe = LightningConversionManager.getRecipe(serverLevel, item.m_32055_())) == null || !LightningConversionManager.isWeatherMatching(serverLevel, recipe.getWeatherId()) || !(shouldCreateLightning = serverLevel.f_46441_.m_188501_() < recipe.getLightningChance())) continue;
            LightningConversionManager.createLightning(serverLevel, item.m_20182_());
            if (!LightningConversionManager.convertItem(serverLevel, item, recipe)) continue;
            item.m_146870_();
        }
    }

    private static LightningConversionRecipe getRecipe(ServerLevel level, ItemStack stack) {
        ArrayList<LightningConversionRecipe> allRecipes = new ArrayList<LightningConversionRecipe>();
        List datapackRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.LIGHTNING_CONVERSION.get());
        allRecipes.addAll(datapackRecipes);
        allRecipes.addAll(customRecipes.values());
        return allRecipes.stream().filter(recipe -> recipe.getIngredient().test(stack)).findFirst().orElse(null);
    }

    private static boolean convertItem(ServerLevel level, ItemEntity item, LightningConversionRecipe recipe) {
        int inputCount = item.m_32055_().m_41613_();
        int successfulConversions = CraftingAPI.calculateSuccessfulConversions(inputCount, recipe.getConversionChance(), level);
        if (successfulConversions <= 0) {
            return false;
        }
        ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
        if (result.m_41619_()) {
            return false;
        }
        result.m_41764_(successfulConversions * result.m_41613_());
        ItemEntity resultEntity = CraftingAPI.createOutputItemWithJump(level, item.m_20182_(), result, item, 0.3);
        return level.m_7967_((Entity)resultEntity);
    }

    private static void createLightning(ServerLevel level, Vec3 position) {
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, (Level)level);
        lightning.m_6027_(position.f_82479_, position.f_82480_, position.f_82481_);
        lightning.m_20874_(false);
        level.m_7967_((Entity)lightning);
    }

    public static void addCustomRecipe(LightningConversionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<LightningConversionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }

    public static void handleLightningStrike(LightningBolt lightning) {
        Level level;
        if (lightning.m_9236_().m_5776_() || !((level = lightning.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 lightningPos = lightning.m_20182_();
        double searchRadius = 3.0;
        AABB searchArea = new AABB(lightningPos.f_82479_ - searchRadius, lightningPos.f_82480_ - searchRadius, lightningPos.f_82481_ - searchRadius, lightningPos.f_82479_ + searchRadius, lightningPos.f_82480_ + searchRadius, lightningPos.f_82481_ + searchRadius);
        for (ItemEntity entity : serverLevel.m_45976_(ItemEntity.class, searchArea)) {
            LightningConversionRecipe recipe;
            if (entity.m_32055_().m_41619_() || (recipe = LightningConversionManager.getRecipe(serverLevel, entity.m_32055_())) == null || !LightningConversionManager.convertItem(serverLevel, entity, recipe)) continue;
            entity.m_146870_();
        }
    }

    private static boolean isWeatherMatching(ServerLevel level, String weatherId) {
        if (weatherId == null || weatherId.isEmpty()) {
            return true;
        }
        switch (weatherId) {
            case "minecraft:clear": {
                return !level.m_46471_() && !level.m_46470_();
            }
            case "minecraft:rain": {
                return level.m_46471_() && !level.m_46470_();
            }
            case "minecraft:thunder": {
                return level.m_46470_();
            }
        }
        return true;
    }
}

