/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.crafting;

import com.xiaoyu.more_world_crafting.crafting.CraftingAPI;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import com.xiaoyu.more_world_crafting.recipe.VoidConversionRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VoidConversionManager {
    private static final Map<UUID, ConversionData> pendingConversions = new HashMap<UUID, ConversionData>();
    private static final Map<ResourceLocation, VoidConversionRecipe> customRecipes = new HashMap<ResourceLocation, VoidConversionRecipe>();
    private static final double VOID_TELEPORT_HEIGHT = 10.0;
    private static final int CONVERSION_DELAY = 10;
    private static final double VOID_THRESHOLD = -65.0;

    public static void tick(Level level) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (Entity entity : serverLevel.m_8583_()) {
            UUID itemId;
            VoidConversionRecipe recipe;
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || (item = (ItemEntity)entity).m_213877_() || item.m_32055_().m_41619_() || !VoidConversionManager.isInVoid(item.m_20182_()) || (recipe = VoidConversionManager.findMatchingRecipe(serverLevel, item.m_32055_())) == null || pendingConversions.containsKey(itemId = item.m_20148_())) continue;
            Player targetPlayer = VoidConversionManager.getItemThrower(item);
            pendingConversions.put(itemId, new ConversionData(itemId, targetPlayer, recipe, item.m_32055_().m_41777_(), item.m_20182_()));
        }
        VoidConversionManager.processConversions(serverLevel);
    }

    private static void processConversions(ServerLevel level) {
        Iterator<Map.Entry<UUID, ConversionData>> iterator = pendingConversions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ConversionData> entry = iterator.next();
            ConversionData data = entry.getValue();
            ++data.tickCount;
            if (data.tickCount < 10) continue;
            boolean itemFound = false;
            for (Entity entity : level.m_8583_()) {
                ItemEntity item;
                if (!(entity instanceof ItemEntity) || !(item = (ItemEntity)entity).m_20148_().equals(data.itemId) || item.m_213877_()) continue;
                item.m_146870_();
                itemFound = true;
                break;
            }
            if (itemFound) {
                VoidConversionManager.performConversion(level, data.originalItemStack, data.recipe, data.targetPlayer, data.position);
            }
            iterator.remove();
        }
    }

    private static Player getItemThrower(ItemEntity item) {
        Entity entity = item.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    private static VoidConversionRecipe findMatchingRecipe(ServerLevel level, ItemStack itemStack) {
        ArrayList<VoidConversionRecipe> allRecipes = new ArrayList<VoidConversionRecipe>();
        List datapackRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.VOID_CONVERSION.get());
        allRecipes.addAll(datapackRecipes);
        allRecipes.addAll(customRecipes.values());
        for (VoidConversionRecipe recipe : allRecipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean performConversion(ServerLevel level, ItemStack originalStack, VoidConversionRecipe recipe, Player targetPlayer, Vec3 position) {
        int inputCount = originalStack.m_41613_();
        if (inputCount <= 0) {
            return false;
        }
        int successfulConversions = CraftingAPI.calculateSuccessfulConversions(inputCount, recipe.getConversionChance(), level);
        if (successfulConversions <= 0) {
            return false;
        }
        ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
        if (result.m_41619_()) {
            return false;
        }
        int resultPerInput = result.m_41613_();
        int totalResultCount = Math.max(1, successfulConversions * resultPerInput);
        result.m_41764_(totalResultCount);
        if (targetPlayer != null && targetPlayer.m_6084_()) {
            boolean added = targetPlayer.m_150109_().m_36054_(result);
            if (added) {
                level.m_6263_(null, targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            } else {
                ItemEntity dropEntity = CraftingAPI.createOutputItem(level, new Vec3(targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_()), result, null);
                level.m_7967_((Entity)dropEntity);
            }
        } else {
            Vec3 teleportPosition = new Vec3(position.f_82479_, position.f_82480_ + 10.0, position.f_82481_);
            ItemEntity resultEntity = CraftingAPI.createOutputItem(level, teleportPosition, result, null);
            level.m_7967_((Entity)resultEntity);
        }
        return true;
    }

    private static boolean isInVoid(Vec3 position) {
        return position.f_82480_ < -65.0;
    }

    public static void addCustomRecipe(VoidConversionRecipe recipe) {
        customRecipes.put(recipe.m_6423_(), recipe);
    }

    public static void removeCustomRecipe(ResourceLocation recipeId) {
        customRecipes.remove(recipeId);
    }

    public static Collection<VoidConversionRecipe> getCustomRecipes() {
        return customRecipes.values();
    }

    private static class ConversionData {
        UUID itemId;
        Player targetPlayer;
        VoidConversionRecipe recipe;
        ItemStack originalItemStack;
        Vec3 position;
        int tickCount;

        ConversionData(UUID itemId, Player targetPlayer, VoidConversionRecipe recipe, ItemStack originalItemStack, Vec3 position) {
            this.itemId = itemId;
            this.targetPlayer = targetPlayer;
            this.recipe = recipe;
            this.originalItemStack = originalItemStack;
            this.position = position;
            this.tickCount = 0;
        }
    }
}

