/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeSerializers;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrushingConversionRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final int minHeight;
    private final float conversionChance;
    private final String gravityType;

    public CrushingConversionRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, int minHeight, float conversionChance, String gravityType) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.minHeight = minHeight;
        this.conversionChance = conversionChance;
        this.gravityType = gravityType;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public float getConversionChance() {
        return this.conversionChance;
    }

    public String getGravityType() {
        return this.gravityType;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CRUSHING_CONVERSION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CRUSHING_CONVERSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrushingConversionRecipe> {
        public CrushingConversionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            JsonObject resultObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)resultObject, (String)"item"), GsonHelper.m_13824_((JsonObject)resultObject, (String)"count", (int)1));
            int minHeight = GsonHelper.m_13824_((JsonObject)json, (String)"min_height", (int)3);
            float conversionChance = GsonHelper.m_13820_((JsonObject)json, (String)"conversion_chance", (float)1.0f);
            String gravityType = GsonHelper.m_13851_((JsonObject)json, (String)"gravity_type", (String)"minecraft:sand");
            return new CrushingConversionRecipe(recipeId, ingredient, result, minHeight, conversionChance, gravityType);
        }

        @Nullable
        public CrushingConversionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            int minHeight = buffer.m_130242_();
            float conversionChance = buffer.readFloat();
            String gravityType = buffer.m_130277_();
            return new CrushingConversionRecipe(recipeId, ingredient, result, minHeight, conversionChance, gravityType);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrushingConversionRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.minHeight);
            buffer.writeFloat(recipe.conversionChance);
            buffer.m_130070_(recipe.gravityType);
        }
    }
}

