/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeSerializers;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireConversionRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float conversionChance;
    private final FireType fireType;

    public FireConversionRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float conversionChance, FireType fireType) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.conversionChance = conversionChance;
        this.fireType = fireType;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public float getConversionChance() {
        return this.conversionChance;
    }

    public float getSuccessChance() {
        return this.conversionChance;
    }

    public FireType getFireType() {
        return this.fireType;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FIRE_CONVERSION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FIRE_CONVERSION.get();
    }

    public static enum FireType {
        NORMAL_FIRE("minecraft:fire"),
        SOUL_FIRE("minecraft:soul_fire"),
        CAMPFIRE("minecraft:campfire"),
        SOUL_CAMPFIRE("minecraft:soul_campfire");

        private final String itemId;

        private FireType(String itemId) {
            this.itemId = itemId;
        }

        public String getItemId() {
            return this.itemId;
        }

        public static FireType fromItemId(String itemId) {
            for (FireType type : FireType.values()) {
                if (!type.itemId.equals(itemId)) continue;
                return type;
            }
            return NORMAL_FIRE;
        }
    }

    public static class Serializer
    implements RecipeSerializer<FireConversionRecipe> {
        public FireConversionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            JsonObject resultObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)resultObject, (String)"item"), GsonHelper.m_13824_((JsonObject)resultObject, (String)"count", (int)1));
            float conversionChance = GsonHelper.m_13820_((JsonObject)json, (String)"conversion_chance", (float)1.0f);
            String fireTypeStr = GsonHelper.m_13851_((JsonObject)json, (String)"fire_type", (String)"minecraft:fire");
            FireType fireType = FireType.fromItemId(fireTypeStr);
            return new FireConversionRecipe(recipeId, ingredient, result, conversionChance, fireType);
        }

        @Nullable
        public FireConversionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            float conversionChance = buffer.readFloat();
            FireType fireType = FireType.values()[buffer.readInt()];
            return new FireConversionRecipe(recipeId, ingredient, result, conversionChance, fireType);
        }

        public void toNetwork(FriendlyByteBuf buffer, FireConversionRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeFloat(recipe.conversionChance);
            buffer.writeInt(recipe.fireType.ordinal());
        }
    }
}

