/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeSerializers;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidConversionRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float conversionChance;
    private final Fluid requiredFluid;

    public FluidConversionRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float conversionChance, Fluid requiredFluid) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.conversionChance = conversionChance;
        this.requiredFluid = requiredFluid;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public float getConversionChance() {
        return this.conversionChance;
    }

    public float getSuccessChance() {
        return this.conversionChance;
    }

    public Fluid getRequiredFluid() {
        return this.requiredFluid;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FLUID_CONVERSION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FLUID_CONVERSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<FluidConversionRecipe> {
        public FluidConversionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            JsonObject resultObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)resultObject, (String)"item"), GsonHelper.m_13824_((JsonObject)resultObject, (String)"count", (int)1));
            float conversionChance = GsonHelper.m_13820_((JsonObject)json, (String)"conversion_chance", (float)1.0f);
            String fluidId = GsonHelper.m_13906_((JsonObject)json, (String)"required_fluid");
            Fluid requiredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidId));
            if (requiredFluid == null) {
                throw new IllegalArgumentException("Unknown fluid: " + fluidId);
            }
            return new FluidConversionRecipe(recipeId, ingredient, result, conversionChance, requiredFluid);
        }

        @Nullable
        public FluidConversionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            float conversionChance = buffer.readFloat();
            ResourceLocation fluidId = buffer.m_130281_();
            Fluid requiredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
            return new FluidConversionRecipe(recipeId, ingredient, result, conversionChance, requiredFluid);
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidConversionRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeFloat(recipe.conversionChance);
            buffer.m_130085_(ForgeRegistries.FLUIDS.getKey((Object)recipe.requiredFluid));
        }
    }
}

