/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.more_world_crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeSerializers;
import com.xiaoyu.more_world_crafting.recipe.ModRecipeTypes;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFusionRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final int fusionTime;
    private final Fluid requiredFluid;

    public FluidFusionRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result, int fusionTime, Fluid requiredFluid) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        this.fusionTime = fusionTime;
        this.requiredFluid = requiredFluid;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public int getFusionTime() {
        return this.fusionTime;
    }

    public Fluid getRequiredFluid() {
        return this.requiredFluid;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FLUID_FUSION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FLUID_FUSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<FluidFusionRecipe> {
        public FluidFusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsArray.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientsArray.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientsArray.get(i)));
            }
            JsonObject resultObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)resultObject, (String)"item"), GsonHelper.m_13824_((JsonObject)resultObject, (String)"count", (int)1));
            int fusionTime = GsonHelper.m_13824_((JsonObject)json, (String)"fusion_time", (int)60);
            String fluidId = GsonHelper.m_13906_((JsonObject)json, (String)"required_fluid");
            Fluid requiredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidId));
            if (requiredFluid == null) {
                throw new IllegalArgumentException("Unknown fluid: " + fluidId);
            }
            return new FluidFusionRecipe(recipeId, (NonNullList<Ingredient>)ingredients, result, fusionTime, requiredFluid);
        }

        @Nullable
        public FluidFusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            int fusionTime = buffer.m_130242_();
            ResourceLocation fluidId = buffer.m_130281_();
            Fluid requiredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
            return new FluidFusionRecipe(recipeId, (NonNullList<Ingredient>)ingredients, result, fusionTime, requiredFluid);
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidFusionRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.fusionTime);
            buffer.m_130085_(ForgeRegistries.FLUIDS.getKey((Object)recipe.requiredFluid));
        }
    }
}

