/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeljaghax<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modeljaghax"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart tail1;
    public final ModelPart tail2;
    public final ModelPart arm11;
    public final ModelPart arm21;

    public Modeljaghax(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.tail1 = root.getChild("tail1");
        this.tail2 = root.getChild("tail2");
        this.arm11 = root.getChild("arm11");
        this.arm21 = root.getChild("arm21");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(88, 108).addBox(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-22.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-9.0f, -8.0f, -4.0f, 18.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-7.0f, 6.0f, -4.0f, 14.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition tail1 = partdefinition.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 67).addBox(-5.0f, -3.0f, -7.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)6.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = partdefinition.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(0, 84).addBox(-4.0f, -3.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)6.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition arm11 = partdefinition.addOrReplaceChild("arm11", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)-20.0f, (float)0.0f));
        PartDefinition arm1 = arm11.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(100, 0).addBox(2.0f, -2.0f, -4.0f, 6.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition arm21 = partdefinition.addOrReplaceChild("arm21", CubeListBuilder.create(), PartPose.offset((float)-8.0f, (float)-20.0f, (float)0.0f));
        PartDefinition arm2 = arm21.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(100, 0).addBox(-10.0f, -4.0f, -4.0f, 6.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)3.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.tail1.render(poseStack, buffer, packedLight, packedOverlay);
        this.tail2.render(poseStack, buffer, packedLight, packedOverlay);
        this.arm11.render(poseStack, buffer, packedLight, packedOverlay);
        this.arm21.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.arm11.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.arm21.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

