/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.eternal_tales.client.model.Modelarrow_et_new;
import net.eternal_tales.entity.RedLightningProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RedLightningProjectileRenderer
extends EntityRenderer<RedLightningProjectileEntity> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"eternal_tales:textures/entities/arrow_bloodstone_model.png");
    private final Modelarrow_et_new model;

    public RedLightningProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new Modelarrow_et_new(context.bakeLayer(Modelarrow_et_new.LAYER_LOCATION));
    }

    public void render(RedLightningProjectileEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityIn)));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.tickCount + partialTicks, entityIn.getYRot(), entityIn.getXRot());
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(RedLightningProjectileEntity entity) {
        return texture;
    }
}

