/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.eternal_tales.client.model.Modelsunlin;
import net.eternal_tales.entity.SunlinEntity;
import net.eternal_tales.procedures.RaccoonModelVisualScaleProcedure;
import net.eternal_tales.procedures.SunlinDisplayConditionProcedure;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SunlinRenderer
extends MobRenderer<SunlinEntity, Modelsunlin<SunlinEntity>> {
    public SunlinRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelsunlin(context.bakeLayer(Modelsunlin.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<SunlinEntity, Modelsunlin<SunlinEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"eternal_tales:textures/entities/sunlin_pumba.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SunlinEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (SunlinDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsunlin)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(SunlinEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)RaccoonModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SunlinEntity entity) {
        return ResourceLocation.parse((String)"eternal_tales:textures/entities/sunlin.png");
    }
}

