/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.entity;

import java.util.EnumSet;
import net.eternal_tales.procedures.MoonwormSegmentCheckProcedure;
import net.eternal_tales.procedures.MoonwormSegmentEntityIsHurtProcedure;
import net.eternal_tales.procedures.MoonwormSegmentOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class MoonwormSegmentEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_n = SynchedEntityData.defineId(MoonwormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public MoonwormSegmentEntity(EntityType<MoonwormSegmentEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_n, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return MoonwormSegmentEntity.this.getTarget() != null && !MoonwormSegmentEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return MoonwormSegmentEntity.this.getMoveControl().hasWanted() && MoonwormSegmentEntity.this.getTarget() != null && MoonwormSegmentEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = MoonwormSegmentEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                MoonwormSegmentEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
            }

            public void tick() {
                LivingEntity livingentity = MoonwormSegmentEntity.this.getTarget();
                if (MoonwormSegmentEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    MoonwormSegmentEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = MoonwormSegmentEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        MoonwormSegmentEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = MoonwormSegmentEntity.this.getRandom();
                double dir_x = MoonwormSegmentEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = MoonwormSegmentEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = MoonwormSegmentEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }

            public boolean canUse() {
                double x = MoonwormSegmentEntity.this.getX();
                double y = MoonwormSegmentEntity.this.getY();
                double z = MoonwormSegmentEntity.this.getZ();
                MoonwormSegmentEntity entity = MoonwormSegmentEntity.this;
                Level world = MoonwormSegmentEntity.this.level();
                return super.canUse() && MoonwormSegmentCheckProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MoonwormSegmentEntity.this.getX();
                double y = MoonwormSegmentEntity.this.getY();
                double z = MoonwormSegmentEntity.this.getZ();
                MoonwormSegmentEntity entity = MoonwormSegmentEntity.this;
                Level world = MoonwormSegmentEntity.this.level();
                return super.canContinueToUse() && MoonwormSegmentCheckProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = MoonwormSegmentEntity.this.getX();
                double y = MoonwormSegmentEntity.this.getY();
                double z = MoonwormSegmentEntity.this.getZ();
                MoonwormSegmentEntity entity = MoonwormSegmentEntity.this;
                Level world = MoonwormSegmentEntity.this.level();
                return super.canUse() && MoonwormSegmentCheckProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MoonwormSegmentEntity.this.getX();
                double y = MoonwormSegmentEntity.this.getY();
                double z = MoonwormSegmentEntity.this.getZ();
                MoonwormSegmentEntity entity = MoonwormSegmentEntity.this;
                Level world = MoonwormSegmentEntity.this.level();
                return super.canContinueToUse() && MoonwormSegmentCheckProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = MoonwormSegmentEntity.this.getX();
                double y = MoonwormSegmentEntity.this.getY();
                double z = MoonwormSegmentEntity.this.getZ();
                MoonwormSegmentEntity entity = MoonwormSegmentEntity.this;
                Level world = MoonwormSegmentEntity.this.level();
                return super.canUse() && MoonwormSegmentCheckProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MoonwormSegmentEntity.this.getX();
                double y = MoonwormSegmentEntity.this.getY();
                double z = MoonwormSegmentEntity.this.getZ();
                MoonwormSegmentEntity entity = MoonwormSegmentEntity.this;
                Level world = MoonwormSegmentEntity.this.level();
                return super.canContinueToUse() && MoonwormSegmentCheckProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MoonwormSegmentEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        MoonwormSegmentEntityIsHurtProcedure.execute((LevelAccessor)world, x, y, z, sourceentity);
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datan", ((Integer)this.entityData.get(DATA_n)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datan")) {
            this.entityData.set(DATA_n, (Object)compound.getInt("Datan"));
        }
    }

    public void baseTick() {
        super.baseTick();
        MoonwormSegmentOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 1024.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

