/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.fluid;

import net.eternal_tales.init.EternalTalesModBlocks;
import net.eternal_tales.init.EternalTalesModFluidTypes;
import net.eternal_tales.init.EternalTalesModFluids;
import net.eternal_tales.init.EternalTalesModItems;
import net.eternal_tales.init.EternalTalesModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class BloodFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)EternalTalesModFluidTypes.BLOOD_TYPE.get(), () -> (Fluid)EternalTalesModFluids.BLOOD.get(), () -> (Fluid)EternalTalesModFluids.FLOWING_BLOOD.get()).explosionResistance(100.0f).bucket(() -> (Item)EternalTalesModItems.BLOOD_BUCKET.get()).block(() -> (LiquidBlock)EternalTalesModBlocks.BLOOD.get());

    private BloodFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)EternalTalesModParticleTypes.BLOOD_DRIP_PARTICLE.get();
    }

    public static class Flowing
    extends BloodFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends BloodFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

