/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.eternal_tales.EternalTalesMod;
import net.eternal_tales.init.EternalTalesModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class EternalTalesModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"eternal_tales");
    public static final DeferredHolder<VillagerProfession, VillagerProfession> NECROMANCER_VILLAGER_PROFESSION = EternalTalesModVillagerProfessions.registerProfession("necromancer_villager_profession", () -> (Block)EternalTalesModBlocks.PUMPKIN_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.pumpkin.carve")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> ARCTIC_VILLAGER_PROFESSION = EternalTalesModVillagerProfessions.registerProfession("arctic_villager_profession", () -> (Block)EternalTalesModBlocks.SNOW_MAKER.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.snow.break")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> GARDENER_VILLAGER_PROFESSION = EternalTalesModVillagerProfessions.registerProfession("gardener_villager_profession", () -> (Block)EternalTalesModBlocks.GARDENERS_POT.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.bone_meal.use")));

    private static DeferredHolder<VillagerProfession, VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> EternalTalesModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.value() == EternalTalesModVillagerProfessions.POI_TYPES.get((Object)name).poiType.value();
            return new VillagerProfession("eternal_tales:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.forState((BlockState)block.defaultBlockState());
                if (existingCheck.isPresent()) {
                    EternalTalesMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()), 1, 1);
                registerHelper.register(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)name), (Object)poiType);
                entry.getValue().poiType = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

