/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.item;

import java.util.List;
import net.eternal_tales.procedures.FabulousDefenderOnPlayerStoppedUsingProcedure;
import net.eternal_tales.procedures.PlayerHaveAreiArrowProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FabulousDefenderItem
extends Item {
    public FabulousDefenderItem() {
        super(new Item.Properties().durability(1000));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_0"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_1"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_2"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_3"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_4"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_5"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_6"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_7"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_8"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.fabulous_defender.description_9"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        PlayerHaveAreiArrowProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        FabulousDefenderOnPlayerStoppedUsingProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
    }
}

