/*
 * Decompiled with CFR 0.152.
 */
package com.griefprevention.util;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record IntVector(int x, int y, int z) {
    public IntVector(@NotNull Block block) {
        this(block.getX(), block.getY(), block.getZ());
    }

    public IntVector(@NotNull Location location) {
        this(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public IntVector(@NotNull Vector vector) {
        this(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @NotNull
    public Block toBlock(@NotNull World world) {
        return world.getBlockAt(this.x(), this.y(), this.z());
    }

    @Contract(value="_ -> new")
    @NotNull
    public Location toLocation(@Nullable World world) {
        return new Location(world, (double)this.x(), (double)this.y(), (double)this.z());
    }

    @Contract(value=" -> new")
    @NotNull
    public BlockVector toVector() {
        return new BlockVector(this.x(), this.y(), this.z());
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public IntVector add(int dX, int dY, int dZ) {
        return new IntVector(this.x() + dX, this.y() + dY, this.z() + dZ);
    }

    @Contract(value="_ -> new")
    @NotNull
    public IntVector add(@NotNull IntVector other) {
        return new IntVector(this.x() + other.x(), this.y() + other.y(), this.z() + other.z());
    }

    public int distanceSquared(@NotNull IntVector other) {
        int dX = this.x() - other.x();
        int dY = this.y() - other.y();
        int dZ = this.z() - other.z();
        return dX * dX + dY * dY + dZ * dZ;
    }

    public boolean isChunkLoaded(@NotNull World world) {
        return world.isChunkLoaded(this.x() >> 4, this.z() >> 4);
    }
}

