/*
 * Decompiled with CFR 0.152.
 */
package com.griefprevention.visualization.impl;

import com.griefprevention.util.IntVector;
import com.griefprevention.visualization.BlockElement;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

final class FakeBlockElement
extends BlockElement {
    @NotNull
    private final BlockData realBlock;
    @NotNull
    private final BlockData visualizedBlock;

    FakeBlockElement(@NotNull IntVector intVector, @NotNull BlockData realBlock, @NotNull BlockData visualizedBlock) {
        super(intVector);
        this.realBlock = realBlock;
        this.visualizedBlock = visualizedBlock;
    }

    @Override
    protected void draw(@NotNull Player player, @NotNull World world) {
        if (!this.getCoordinate().isChunkLoaded(world)) {
            return;
        }
        player.sendBlockChange(this.getCoordinate().toLocation(world), this.visualizedBlock);
    }

    @Override
    protected void erase(@NotNull Player player, @NotNull World world) {
        player.sendBlockChange(this.getCoordinate().toLocation(world), this.realBlock);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        FakeBlockElement that = (FakeBlockElement)other;
        return this.realBlock.equals((Object)that.realBlock) && this.visualizedBlock.equals((Object)that.visualizedBlock);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

