/*
 * Decompiled with CFR 0.152.
 */
package com.griefprevention.visualization.impl;

import com.griefprevention.util.IntVector;
import com.griefprevention.visualization.BlockBoundaryVisualization;
import com.griefprevention.visualization.Boundary;
import com.griefprevention.visualization.VisualizationType;
import com.griefprevention.visualization.impl.FakeBlockElement;
import java.util.function.Consumer;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.jetbrains.annotations.NotNull;

public class FakeBlockVisualization
extends BlockBoundaryVisualization {
    protected final boolean waterTransparent;

    public FakeBlockVisualization(@NotNull World world, @NotNull IntVector visualizeFrom, int height) {
        super(world, visualizeFrom, height);
        this.waterTransparent = visualizeFrom.toBlock(world).getType() == Material.WATER;
    }

    @Override
    @NotNull
    protected @NotNull Consumer<@NotNull IntVector> addCornerElements(@NotNull Boundary boundary) {
        return this.addBlockElement(switch (boundary.type()) {
            case VisualizationType.SUBDIVISION -> Material.IRON_BLOCK.createBlockData();
            case VisualizationType.INITIALIZE_ZONE, VisualizationType.NATURE_RESTORATION_ZONE -> Material.DIAMOND_BLOCK.createBlockData();
            case VisualizationType.CONFLICT_ZONE -> {
                BlockData fakeData = Material.REDSTONE_ORE.createBlockData();
                ((Lightable)fakeData).setLit(true);
                yield fakeData;
            }
            default -> Material.GLOWSTONE.createBlockData();
        });
    }

    @Override
    @NotNull
    protected @NotNull Consumer<@NotNull IntVector> addSideElements(@NotNull Boundary boundary) {
        return this.addBlockElement(switch (boundary.type()) {
            case VisualizationType.ADMIN_CLAIM -> Material.PUMPKIN.createBlockData();
            case VisualizationType.SUBDIVISION -> Material.WHITE_WOOL.createBlockData();
            case VisualizationType.INITIALIZE_ZONE, VisualizationType.NATURE_RESTORATION_ZONE -> Material.DIAMOND_BLOCK.createBlockData();
            case VisualizationType.CONFLICT_ZONE -> Material.NETHERRACK.createBlockData();
            default -> Material.GOLD_BLOCK.createBlockData();
        });
    }

    @NotNull
    private @NotNull Consumer<@NotNull IntVector> addBlockElement(@NotNull BlockData fakeData) {
        return vector -> {
            Block visibleLocation = this.getVisibleLocation((IntVector)vector);
            this.elements.add(new FakeBlockElement(new IntVector(visibleLocation), visibleLocation.getBlockData(), fakeData));
        };
    }

    private Block getVisibleLocation(@NotNull IntVector vector) {
        BlockFace direction;
        Block block = vector.toBlock(this.world);
        BlockFace blockFace = direction = this.isTransparent(block) ? BlockFace.DOWN : BlockFace.UP;
        while (block.getY() >= this.world.getMinHeight() && block.getY() < this.world.getMaxHeight() - 1 && (!this.isTransparent(block.getRelative(BlockFace.UP)) || this.isTransparent(block))) {
            block = block.getRelative(direction);
        }
        return block;
    }

    protected boolean isTransparent(@NotNull Block block) {
        Material blockMaterial = block.getType();
        switch (blockMaterial) {
            case WATER: {
                return this.waterTransparent;
            }
            case SNOW: {
                return false;
            }
        }
        if (blockMaterial.isAir() || Tag.FENCES.isTagged((Keyed)blockMaterial) || Tag.FENCE_GATES.isTagged((Keyed)blockMaterial) || Tag.SIGNS.isTagged((Keyed)blockMaterial) || Tag.WALLS.isTagged((Keyed)blockMaterial) || Tag.WALL_SIGNS.isTagged((Keyed)blockMaterial)) {
            return true;
        }
        return block.getType().isTransparent();
    }
}

